/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyPylon;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileInvisibleMultiblock;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayBlock;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class InvisibleMultiblock
extends BlockDE
implements IHudDisplayBlock,
ITileEntityProvider {
    public static void revertStructure(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            world.func_147465_d(x, y, z, BalanceConfigHandler.energyStorageStructureOuterBlock, BalanceConfigHandler.energyStorageStructureOuterBlockMetadata, 3);
        } else if (metadata == 1) {
            world.func_147465_d(x, y, z, BalanceConfigHandler.energyStorageStructureBlock, BalanceConfigHandler.energyStorageStructureBlockMetadata, 3);
        }
    }

    public InvisibleMultiblock() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(2000.0f);
        this.func_149663_c("invisibleMultiblock");
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconium_block_0");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 0 || metadata == 1;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return metadata == 0 || metadata == 1 ? new TileInvisibleMultiblock() : null;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (metadata == 0) {
            return Item.func_150898_a((Block)BalanceConfigHandler.energyStorageStructureOuterBlock);
        }
        if (metadata == 1) {
            return Item.func_150898_a((Block)BalanceConfigHandler.energyStorageStructureBlock);
        }
        return null;
    }

    public int func_149692_a(int metadata) {
        if (metadata == 0) {
            return BalanceConfigHandler.energyStorageStructureOuterBlockMetadata;
        }
        if (metadata == 1) {
            return BalanceConfigHandler.energyStorageStructureBlockMetadata;
        }
        return super.func_149692_a(metadata);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0 || metadata == 1) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileInvisibleMultiblock)) {
                LogHelper.error("Missing Tile Entity (TileInvisibleMultiblock)");
                return false;
            }
            TileInvisibleMultiblock multiblock = (TileInvisibleMultiblock)tile;
            TileEnergyStorageCore core = multiblock.getMaster();
            if (core == null) {
                this.func_149695_a(world, x, y, z, this);
                return false;
            }
            if (!world.field_72995_K) {
                world.func_147471_g(core.field_145851_c, core.field_145848_d, core.field_145849_e);
                List<String> information = core.getDisplayInformation(false);
                for (String message : information) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(message));
                }
            }
            return true;
        }
        if (metadata == 2) {
            TileEnergyPylon pylon;
            TileEntity tileAbove = world.func_147438_o(x, y + 1, z);
            TileEntity tileBelow = world.func_147438_o(x, y - 1, z);
            TileEnergyPylon tileEnergyPylon = tileAbove instanceof TileEnergyPylon ? (TileEnergyPylon)tileAbove : (pylon = tileBelow instanceof TileEnergyPylon ? (TileEnergyPylon)tileBelow : null);
            if (pylon == null) {
                return false;
            }
            pylon.isReceivingEnergy = !pylon.isReceivingEnergy;
            world.func_147471_g(pylon.field_145851_c, pylon.field_145848_d, pylon.field_145849_e);
            pylon.onActivated();
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0 || metadata == 1) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileInvisibleMultiblock)) {
                LogHelper.error("Missing Tile Entity (TileInvisibleMultiblock)");
                InvisibleMultiblock.revertStructure(world, x, y, z);
                return;
            }
            TileInvisibleMultiblock multiblock = (TileInvisibleMultiblock)tile;
            TileEnergyStorageCore core = multiblock.getMaster();
            if (core == null) {
                LogHelper.error("Master = null reverting!");
                InvisibleMultiblock.revertStructure(world, x, y, z);
                return;
            }
            if (core.isOnline()) {
                core.validateStructure(core.getTier() == 1);
            } else {
                InvisibleMultiblock.revertStructure(world, x, y, z);
            }
        } else if (metadata == 2 && world.func_147439_a(x, y + 1, z) != ModBlocks.energyPylon && world.func_147439_a(x, y - 1, z) != ModBlocks.energyPylon) {
            world.func_147449_b(x, y, z, Blocks.field_150359_w);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockBroken, int metadata) {
        TileInvisibleMultiblock multiblock;
        TileEnergyStorageCore core;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileInvisibleMultiblock && (core = (multiblock = (TileInvisibleMultiblock)tile).getMaster()) != null && core.isOnline()) {
            world.func_72921_c(x, y, z, 0, 2);
            core.validateStructure(core.getTier() == 1);
        }
        super.func_149749_a(world, x, y, z, blockBroken, metadata);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0 || metadata == 1) {
            TileInvisibleMultiblock multiblock;
            TileEnergyStorageCore core;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileInvisibleMultiblock && (core = (multiblock = (TileInvisibleMultiblock)tile).getMaster()) != null) {
                return AxisAlignedBB.func_72330_a((double)core.field_145851_c, (double)core.field_145848_d, (double)core.field_145849_e, (double)((double)core.field_145851_c + 0.5), (double)((double)core.field_145848_d + 0.5), (double)((double)core.field_145849_e + 0.5));
            }
            return super.func_149633_g(world, x, y, z);
        }
        if (metadata == 2) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.49), (double)((double)y + 0.49), (double)((double)z + 0.49), (double)((double)x + 0.51), (double)((double)y + 0.51), (double)((double)z + 0.51));
        }
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 2) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
        }
        return super.func_149668_a(world, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            return new ItemStack(BalanceConfigHandler.energyStorageStructureOuterBlock, 1, BalanceConfigHandler.energyStorageStructureOuterBlockMetadata);
        }
        if (metadata == 1) {
            return new ItemStack(BalanceConfigHandler.energyStorageStructureBlock, 1, BalanceConfigHandler.energyStorageStructureBlockMetadata);
        }
        return new ItemStack(Blocks.field_150359_w);
    }

    @Override
    public List<String> getDisplayData(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0 || metadata == 1) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileInvisibleMultiblock)) {
                LogHelper.error("Missing Tile Entity (TileInvisibleMultiblock getDisplayData)");
                return Collections.emptyList();
            }
            TileInvisibleMultiblock multiblock = (TileInvisibleMultiblock)tile;
            TileEnergyStorageCore core = multiblock.getMaster();
            if (core != null) {
                return core.getDisplayInformation(true);
            }
        }
        return Collections.emptyList();
    }
}

