/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.Identifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.FunctionParameter;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.Expression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.FunctionCallExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.EmptyDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.Statement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.FunctionPrototype;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.Root;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.match.Matcher;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.transform.ASTParser;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.transform.Template;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.transform.Parameters;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatibilityTransformer {
    static Logger LOGGER = LogManager.getLogger(CompatibilityTransformer.class);
    private static final AutoHintedMatcher<Expression> sildursWaterFract = new AutoHintedMatcher<Expression>("fract(worldpos.y + 0.001)", Matcher.expressionPattern);
    private static final ShaderType[] pipeline = new ShaderType[]{ShaderType.VERTEX, ShaderType.GEOMETRY, ShaderType.FRAGMENT};
    private static final DeclarationMatcher outDeclarationMatcher = new DeclarationMatcher(StorageQualifier.StorageType.OUT);
    private static final DeclarationMatcher inDeclarationMatcher = new DeclarationMatcher(StorageQualifier.StorageType.IN);
    private static final String tagPrefix = "iris_template_";
    private static final Template<ExternalDeclaration> declarationTemplate = Template.withExternalDeclaration("out __type __name;");
    private static final Template<Statement> initTemplate = Template.withStatement("__decl = __value;");
    private static final Template<ExternalDeclaration> variableTemplate = Template.withExternalDeclaration("__type __internalDecl;");
    private static final Template<Statement> statementTemplate = Template.withStatement("__oldDecl = vec3(__internalDecl);");
    private static final Template<Statement> statementTemplateVector = Template.withStatement("__oldDecl = vec3(__internalDecl, vec4(0));");

    private static StorageQualifier getConstQualifier(TypeQualifier qualifier) {
        if (qualifier == null) {
            return null;
        }
        for (TypeQualifierPart constQualifier : qualifier.getChildren()) {
            if (!(constQualifier instanceof StorageQualifier)) continue;
            StorageQualifier storageQualifier = (StorageQualifier)constQualifier;
            if (storageQualifier.storageType != StorageQualifier.StorageType.CONST) continue;
            return storageQualifier;
        }
        return null;
    }

    public static void transformEach(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        boolean emptyDeclarationHit;
        if (parameters.type == PatchShaderType.VERTEX && root.replaceExpressionMatches(t, sildursWaterFract, "fract(worldpos.y + 0.01)")) {
            Iris.logger.warn("Patched fract(worldpos.y + 0.001) to fract(worldpos.y + 0.01) to fix waving water disconnecting from other water blocks; See https://github.com/IrisShaders/Iris/issues/509");
        }
        HashMap constFunctions = new HashMap();
        HashSet<String> processingSet = new HashSet<String>();
        LinkedList<FunctionDefinition> unusedFunctions = new LinkedList<FunctionDefinition>();
        for (FunctionDefinition functionDefinition : root.nodeIndex.get(FunctionDefinition.class)) {
            FunctionPrototype prototype = functionDefinition.getFunctionPrototype();
            String functionName = prototype.getName().getName();
            if (!functionName.equals("main") && root.identifierIndex.getStream(functionName).count() <= 1L) {
                unusedFunctions.add(functionDefinition);
                if (PatchedShaderPrinter.prettyPrintShaders) {
                    LOGGER.warn("Removing unused function " + functionName);
                    continue;
                }
                if (unusedFunctions.size() != 1) continue;
                LOGGER.warn("Removing unused function " + functionName + " and omitting further such messages outside of debug mode. See debugging.md for more information.");
                continue;
            }
            if (prototype.getChildren().isEmpty()) continue;
            HashSet<String> names = new HashSet<String>(prototype.getChildren().size());
            for (FunctionParameter parameter : prototype.getChildren()) {
                if (CompatibilityTransformer.getConstQualifier(parameter.getType().getTypeQualifier()) == null) continue;
                String name = parameter.getName().getName();
                names.add(name);
                processingSet.add(name);
            }
            if (names.isEmpty()) continue;
            constFunctions.put(functionDefinition, names);
        }
        for (FunctionDefinition functionDefinition : unusedFunctions) {
            functionDefinition.detachAndDelete();
        }
        boolean constDeclarationHit = false;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(processingSet);
        while (!arrayDeque.isEmpty()) {
            String name = (String)arrayDeque.poll();
            processingSet.remove(name);
            for (Identifier id : root.identifierIndex.get(name)) {
                TypeQualifier qualifier;
                StorageQualifier constQualifier;
                Set constIdsInFunction;
                FunctionDefinition inDefinition;
                TypeAndInitDeclaration taid;
                ReferenceExpression reference = id.getAncestor(ReferenceExpression.class);
                if (reference == null || (taid = reference.getAncestor(TypeAndInitDeclaration.class)) == null || (inDefinition = taid.getAncestor(FunctionDefinition.class)) == null || (constIdsInFunction = (Set)constFunctions.get(inDefinition)) == null || !constIdsInFunction.contains(name) || (constQualifier = CompatibilityTransformer.getConstQualifier(qualifier = taid.getType().getTypeQualifier())) == null) continue;
                constQualifier.detachAndDelete();
                if (qualifier.getChildren().isEmpty()) {
                    qualifier.detachAndDelete();
                }
                constDeclarationHit = true;
                for (DeclarationMember member : taid.getMembers()) {
                    String memberName = member.getName().getName();
                    if (constIdsInFunction.contains(memberName)) {
                        throw new IllegalStateException("Illegal redefinition of const parameter " + name);
                    }
                    constIdsInFunction.add(memberName);
                    if (processingSet.contains(memberName)) continue;
                    arrayDeque.add(memberName);
                    processingSet.add(memberName);
                }
            }
        }
        if (constDeclarationHit) {
            LOGGER.warn("Removed the const keyword from declarations that use const parameters. See debugging.md for more information.");
        }
        if (emptyDeclarationHit = root.process(root.nodeIndex.getStream(EmptyDeclaration.class), ASTNode::detachAndDelete)) {
            LOGGER.warn("Removed empty external declarations (\";\").");
        }
    }

    private static Statement getInitializer(Root root, String name, Type type) {
        return initTemplate.getInstanceFor(root, new Identifier(name), type.isScalar() ? LiteralExpression.getDefaultValue(type) : Root.indexNodes(root, () -> new FunctionCallExpression(new Identifier(type.getMostCompactName()), Stream.of(LiteralExpression.getDefaultValue(type)))));
    }

    private static TypeQualifier makeQualifierOut(TypeQualifier typeQualifier) {
        for (TypeQualifierPart qualifierPart : typeQualifier.getParts()) {
            if (!(qualifierPart instanceof StorageQualifier)) continue;
            StorageQualifier storageQualifier = (StorageQualifier)qualifierPart;
            if (((StorageQualifier)qualifierPart).storageType != StorageQualifier.StorageType.IN) continue;
            storageQualifier.storageType = StorageQualifier.StorageType.OUT;
        }
        return typeQualifier;
    }

    public static void transformGrouped(ASTParser t, Map<PatchShaderType, TranslationUnit> trees, Parameters parameters) {
        ShaderType prevType = null;
        for (int i = 0; i < pipeline.length; ++i) {
            ShaderType type = pipeline[i];
            PatchShaderType[] patchTypes = PatchShaderType.fromGlShaderType(type);
            boolean hasAny = false;
            for (PatchShaderType currentType : patchTypes) {
                if (trees.get((Object)currentType) == null) continue;
                hasAny = true;
            }
            if (!hasAny) continue;
            if (prevType == null) {
                prevType = type;
                continue;
            }
            PatchShaderType prevPatchTypes = PatchShaderType.fromGlShaderType(prevType)[0];
            TranslationUnit prevTree = trees.get((Object)prevPatchTypes);
            Root prevRoot = prevTree.getRoot();
            if (prevRoot.identifierIndex.prefixQueryFlat(tagPrefix).findAny().isPresent()) {
                LOGGER.warn("The prefix tag iris_template_ is used in the shader, bailing compatibility transformation.");
                return;
            }
            HashMap<String, BuiltinNumericTypeSpecifier> outDeclarations = new HashMap<String, BuiltinNumericTypeSpecifier>();
            for (DeclarationExternalDeclaration declarationExternalDeclaration : prevRoot.nodeIndex.get(DeclarationExternalDeclaration.class)) {
                if (!outDeclarationMatcher.matchesSpecialized(declarationExternalDeclaration, prevType)) continue;
                BuiltinNumericTypeSpecifier extractedType = outDeclarationMatcher.getNodeMatch("type", BuiltinNumericTypeSpecifier.class);
                for (DeclarationMember member : outDeclarationMatcher.getNodeMatch("name*", DeclarationMember.class).getAncestor(TypeAndInitDeclaration.class).getMembers()) {
                    String name = member.getName().getName();
                    if (name.startsWith("gl_")) continue;
                    outDeclarations.put(name, extractedType);
                }
            }
            for (PatchShaderType currentType : patchTypes) {
                TranslationUnit currentTree = trees.get((Object)currentType);
                if (currentTree == null) continue;
                Root currentRoot = currentTree.getRoot();
                for (ExternalDeclaration externalDeclaration : currentRoot.nodeIndex.get(DeclarationExternalDeclaration.class)) {
                    if (!inDeclarationMatcher.matchesSpecialized(externalDeclaration, currentType.glShaderType)) continue;
                    BuiltinNumericTypeSpecifier inTypeSpecifier = inDeclarationMatcher.getNodeMatch("type", BuiltinNumericTypeSpecifier.class);
                    for (DeclarationMember inDeclarationMember : inDeclarationMatcher.getNodeMatch("name*", DeclarationMember.class).getAncestor(TypeAndInitDeclaration.class).getMembers()) {
                        String name = inDeclarationMember.getName().getName();
                        if (name.startsWith("gl_")) continue;
                        if (!outDeclarations.containsKey(name)) {
                            if (!currentRoot.identifierIndex.getAncestors(name, ReferenceExpression.class).findAny().isPresent()) continue;
                            if (inTypeSpecifier == null) {
                                LOGGER.warn("The in declaration '" + name + "' in the " + currentType.glShaderType.name() + " shader that has a missing corresponding out declaration in the previous stage " + prevType.name() + " has a non-numeric type and could not be compatibility-patched. See debugging.md for more information.");
                                continue;
                            }
                            Type inType = inTypeSpecifier.type;
                            TypeQualifier outQualifier = (TypeQualifier)inDeclarationMatcher.getNodeMatch("qualifier").cloneInto(prevRoot);
                            CompatibilityTransformer.makeQualifierOut(outQualifier);
                            prevTree.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, declarationTemplate.getInstanceFor(prevRoot, outQualifier, inTypeSpecifier.cloneInto(prevRoot), new Identifier(name)));
                            prevTree.prependMain(CompatibilityTransformer.getInitializer(prevRoot, name, inType));
                            outDeclarations.put(name, null);
                            LOGGER.warn("The in declaration '" + name + "' in the " + currentType.glShaderType.name() + " shader is missing a corresponding out declaration in the previous stage " + prevType.name() + " and has been compatibility-patched. See debugging.md for more information.");
                            continue;
                        }
                        BuiltinNumericTypeSpecifier outTypeSpecifier = (BuiltinNumericTypeSpecifier)outDeclarations.get(name);
                        if (outTypeSpecifier == null) continue;
                        Type inType = inTypeSpecifier.type;
                        Type outType = outTypeSpecifier.type;
                        if (inType == outType) {
                            if (prevRoot.identifierIndex.get(name).size() > 1) continue;
                            prevTree.prependMain(CompatibilityTransformer.getInitializer(prevRoot, name, inType));
                            outDeclarations.put(name, null);
                            continue;
                        }
                        if (outType.getDimension() != inType.getDimension()) {
                            LOGGER.warn("The in declaration '" + name + "' in the " + currentType.glShaderType.name() + " shader has a mismatching dimensionality (scalar/vector/matrix) with the out declaration in the previous stage " + prevType.name() + " and could not be compatibility-patched. See debugging.md for more information.");
                            continue;
                        }
                        boolean isVector = outType.isVector();
                        String newName = tagPrefix + name;
                        prevRoot.identifierIndex.rename(name, newName);
                        TypeAndInitDeclaration outDeclaration = outTypeSpecifier.getAncestor(TypeAndInitDeclaration.class);
                        if (outDeclaration == null) continue;
                        List<DeclarationMember> outMembers = outDeclaration.getMembers();
                        DeclarationMember outMember = null;
                        for (DeclarationMember member : outMembers) {
                            if (!member.getName().getName().equals(newName)) continue;
                            outMember = member;
                        }
                        if (outMember == null) {
                            throw new IllegalStateException("The targeted out declaration member is missing!");
                        }
                        outMember.getName().replaceByAndDelete(new Identifier(name));
                        if (outMembers.size() > 1) {
                            outMember.detach();
                            outTypeSpecifier = outTypeSpecifier.cloneInto(prevRoot);
                            DeclarationExternalDeclaration singleOutDeclaration = (DeclarationExternalDeclaration)declarationTemplate.getInstanceFor(prevRoot, CompatibilityTransformer.makeQualifierOut(outDeclaration.getType().getTypeQualifier().cloneInto(prevRoot)), outTypeSpecifier, new Identifier(name));
                            ((TypeAndInitDeclaration)singleOutDeclaration.getDeclaration()).getMembers().set(0, outMember);
                            prevTree.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, singleOutDeclaration);
                        }
                        prevTree.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, variableTemplate.getInstanceFor(prevRoot, outTypeSpecifier.cloneInto(prevRoot), new Identifier(newName)));
                        prevTree.appendMain((isVector && outType.getDimensions()[0] < inType.getDimensions()[0] ? statementTemplateVector : statementTemplate).getInstanceFor(prevRoot, new Identifier(name), new Identifier(newName), inTypeSpecifier.cloneInto(prevRoot)));
                        outTypeSpecifier.replaceByAndDelete(inTypeSpecifier.cloneInto(prevRoot));
                        outDeclarations.put(name, null);
                        LOGGER.warn("The out declaration '" + name + "' in the " + prevType.name() + " shader has a different type " + outType.getMostCompactName() + " than the corresponding in declaration of type " + inType.getMostCompactName() + " in the following stage " + currentType.glShaderType.name() + " and has been compatibility-patched. See debugging.md for more information.");
                    }
                }
            }
            prevType = type;
        }
    }

    static {
        declarationTemplate.markLocalReplacement((ASTNode)((Object)CompatibilityTransformer.declarationTemplate.getSourceRoot().nodeIndex.getOne(TypeQualifier.class)));
        declarationTemplate.markLocalReplacement("__type", TypeSpecifier.class);
        declarationTemplate.markIdentifierReplacement("__name");
        initTemplate.markIdentifierReplacement("__decl");
        initTemplate.markLocalReplacement("__value", ReferenceExpression.class);
        variableTemplate.markLocalReplacement("__type", TypeSpecifier.class);
        variableTemplate.markIdentifierReplacement("__internalDecl");
        statementTemplate.markIdentifierReplacement("__oldDecl");
        statementTemplate.markIdentifierReplacement("__internalDecl");
        statementTemplate.markLocalReplacement(CompatibilityTransformer.statementTemplate.getSourceRoot().nodeIndex.getStream(BuiltinNumericTypeSpecifier.class).filter(specifier -> specifier.type == Type.F32VEC3).findAny().get());
        statementTemplateVector.markIdentifierReplacement("__oldDecl");
        statementTemplateVector.markIdentifierReplacement("__internalDecl");
        statementTemplateVector.markLocalReplacement(CompatibilityTransformer.statementTemplateVector.getSourceRoot().nodeIndex.getStream(BuiltinNumericTypeSpecifier.class).filter(specifier -> specifier.type == Type.F32VEC3).findAny().get());
    }

    private static class DeclarationMatcher
    extends AutoHintedMatcher<ExternalDeclaration> {
        private final StorageQualifier.StorageType storageType;

        public DeclarationMatcher(StorageQualifier.StorageType storageType) {
            super("out float name;", Matcher.externalDeclarationPattern);
            this.storageType = storageType;
            this.markClassWildcard("qualifier", (ASTNode)((Object)((ExternalDeclaration)this.pattern).getRoot().nodeIndex.getOne(TypeQualifier.class)));
            this.markClassWildcard("type", (ASTNode)((Object)((ExternalDeclaration)this.pattern).getRoot().nodeIndex.getOne(BuiltinNumericTypeSpecifier.class)));
            this.markClassWildcard("name*", ((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getOne("name").getAncestor(DeclarationMember.class));
        }

        public boolean matchesSpecialized(ExternalDeclaration tree, ShaderType shaderType) {
            boolean result = super.matchesExtract(tree);
            if (!result) {
                return false;
            }
            TypeQualifier qualifier = this.getNodeMatch("qualifier", TypeQualifier.class);
            for (TypeQualifierPart part : qualifier.getParts()) {
                if (!(part instanceof StorageQualifier)) continue;
                StorageQualifier storageQualifier = (StorageQualifier)part;
                StorageQualifier.StorageType qualifierStorageType = storageQualifier.storageType;
                if (qualifierStorageType != this.storageType && (qualifierStorageType != StorageQualifier.StorageType.VARYING || !(shaderType == ShaderType.VERTEX && this.storageType == StorageQualifier.StorageType.OUT || shaderType == ShaderType.GEOMETRY && this.storageType == StorageQualifier.StorageType.OUT) && (shaderType != ShaderType.FRAGMENT || this.storageType != StorageQualifier.StorageType.IN))) continue;
                return true;
            }
            return false;
        }
    }
}

