/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.block;

import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.RenderPassAPI;
import mist475.mcpatcherforge.config.MCPatcherForgeConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderBlocksUtils {
    public static final boolean enableBetterGrass = MCPatcherForgeConfig.instance().betterGrass;
    private static final Block grassBlock = BlockAPI.getFixedBlock("minecraft:grass");
    private static final Block snowBlock = BlockAPI.getFixedBlock("minecraft:snow_layer");
    private static final Block craftedSnowBlock = BlockAPI.getFixedBlock("minecraft:snow");
    private static final int COLOR = 0;
    private static final int NONCOLOR = 1;
    private static final int COLOR_AND_NONCOLOR = 2;
    private static final int[] colorMultiplierType = new int[6];
    private static final float[][] nonAOMultipliers = new float[6][3];
    public static final float[] AO_BASE = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public static int layerIndex;
    public static IIcon blankIcon;

    public static void setupColorMultiplier(Block block, IBlockAccess blockAccess, int i, int j, int k, boolean haveOverrideTexture, float r, float g, float b) {
        if (haveOverrideTexture || !RenderPassAPI.instance.useColorMultiplierThisPass(block)) {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        } else if (block == grassBlock) {
            RenderBlocksUtils.colorMultiplierType[0] = 1;
            if (enableBetterGrass) {
                if (RenderBlocksUtils.isSnowCovered(blockAccess, i, j, k)) {
                    RenderBlocksUtils.colorMultiplierType[2] = 1;
                    RenderBlocksUtils.colorMultiplierType[3] = 1;
                    RenderBlocksUtils.colorMultiplierType[4] = 1;
                    RenderBlocksUtils.colorMultiplierType[5] = 1;
                } else {
                    RenderBlocksUtils.colorMultiplierType[2] = block == BlockAPI.getBlockAt(blockAccess, i, --j, k - 1) && !RenderBlocksUtils.isSnowCovered(blockAccess, i, j, k - 1) ? 0 : 2;
                    RenderBlocksUtils.colorMultiplierType[3] = block == BlockAPI.getBlockAt(blockAccess, i, j, k + 1) && !RenderBlocksUtils.isSnowCovered(blockAccess, i, j, k + 1) ? 0 : 2;
                    RenderBlocksUtils.colorMultiplierType[4] = block == BlockAPI.getBlockAt(blockAccess, i - 1, j, k) && !RenderBlocksUtils.isSnowCovered(blockAccess, i - 1, j, k) ? 0 : 2;
                    RenderBlocksUtils.colorMultiplierType[5] = block == BlockAPI.getBlockAt(blockAccess, i + 1, j, k) && !RenderBlocksUtils.isSnowCovered(blockAccess, i + 1, j, k) ? 0 : 2;
                }
            } else {
                RenderBlocksUtils.colorMultiplierType[2] = 2;
                RenderBlocksUtils.colorMultiplierType[3] = 2;
                RenderBlocksUtils.colorMultiplierType[4] = 2;
                RenderBlocksUtils.colorMultiplierType[5] = 2;
            }
        } else {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        }
        if (!RenderBlocksUtils.isAmbientOcclusionEnabled() || BlockAPI.getBlockLightValue(block) != 0) {
            RenderBlocksUtils.setupColorMultiplier(0, r, g, b);
            RenderBlocksUtils.setupColorMultiplier(1, r, g, b);
            RenderBlocksUtils.setupColorMultiplier(2, r, g, b);
            RenderBlocksUtils.setupColorMultiplier(3, r, g, b);
            RenderBlocksUtils.setupColorMultiplier(4, r, g, b);
            RenderBlocksUtils.setupColorMultiplier(5, r, g, b);
        }
    }

    public static void setupColorMultiplier(Block block, boolean useColor) {
        if (block == grassBlock || !useColor) {
            RenderBlocksUtils.colorMultiplierType[0] = 1;
            RenderBlocksUtils.colorMultiplierType[2] = 1;
            RenderBlocksUtils.colorMultiplierType[3] = 1;
            RenderBlocksUtils.colorMultiplierType[4] = 1;
            RenderBlocksUtils.colorMultiplierType[5] = 1;
        } else {
            RenderBlocksUtils.colorMultiplierType[0] = 0;
            RenderBlocksUtils.colorMultiplierType[2] = 0;
            RenderBlocksUtils.colorMultiplierType[3] = 0;
            RenderBlocksUtils.colorMultiplierType[4] = 0;
            RenderBlocksUtils.colorMultiplierType[5] = 0;
        }
    }

    private static void setupColorMultiplier(int face, float r, float g, float b) {
        float ao;
        float[] mult = nonAOMultipliers[face];
        mult[0] = ao = AO_BASE[face];
        mult[1] = ao;
        mult[2] = ao;
        if (colorMultiplierType[face] != 1) {
            mult[0] = mult[0] * r;
            mult[1] = mult[1] * g;
            mult[2] = mult[2] * b;
        }
    }

    public static boolean useColorMultiplier(int face) {
        layerIndex = 0;
        return RenderBlocksUtils.useColorMultiplier1(face);
    }

    private static boolean useColorMultiplier1(int face) {
        if (layerIndex == 0) {
            return colorMultiplierType[RenderBlocksUtils.getFaceIndex(face)] == 0;
        }
        return colorMultiplierType[RenderBlocksUtils.getFaceIndex(face)] != 1;
    }

    public static float getColorMultiplierRed(int face) {
        return nonAOMultipliers[RenderBlocksUtils.getFaceIndex(face)][0];
    }

    public static float getColorMultiplierGreen(int face) {
        return nonAOMultipliers[RenderBlocksUtils.getFaceIndex(face)][1];
    }

    public static float getColorMultiplierBlue(int face) {
        return nonAOMultipliers[RenderBlocksUtils.getFaceIndex(face)][2];
    }

    private static int getFaceIndex(int face) {
        return face < 0 ? 1 : face % 6;
    }

    public static IIcon getGrassTexture(Block block, IBlockAccess blockAccess, int i, int j, int k, int face, IIcon topIcon) {
        if (!enableBetterGrass || face < 2) {
            return null;
        }
        boolean isSnow = RenderBlocksUtils.isSnowCovered(blockAccess, i, j, k);
        --j;
        switch (face) {
            case 2: {
                --k;
                break;
            }
            case 3: {
                ++k;
                break;
            }
            case 4: {
                --i;
                break;
            }
            case 5: {
                ++i;
                break;
            }
            default: {
                return null;
            }
        }
        if (block != BlockAPI.getBlockAt(blockAccess, i, j, k)) {
            return null;
        }
        boolean neighborIsSnow = RenderBlocksUtils.isSnowCovered(blockAccess, i, j, k);
        if (isSnow != neighborIsSnow) {
            return null;
        }
        return isSnow ? BlockAPI.getBlockIcon(snowBlock, blockAccess, i, j, k, face) : topIcon;
    }

    private static boolean isSnowCovered(IBlockAccess blockAccess, int i, int j, int k) {
        Block topBlock = BlockAPI.getBlockAt(blockAccess, i, j + 1, k);
        return topBlock == snowBlock || topBlock == craftedSnowBlock;
    }

    public static boolean isAmbientOcclusionEnabled() {
        return Minecraft.func_71379_u();
    }
}

