/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.block;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockAPI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockAPI(FMLControlledNamespacedRegistry<Block> registry) {
        File outputFile = new File("blocks17.txt");
        if (outputFile.isFile()) {
            PrintStream ps = null;
            try {
                ps = new PrintStream(outputFile);
                String[] nameList = new String[4096];
                for (String name17 : registry.func_148742_b()) {
                    int id;
                    Object block = registry.func_82594_a(name17);
                    if (block == null || (id = registry.func_148757_b(block)) < 0 || id >= nameList.length) continue;
                    nameList[id] = name17;
                }
                for (int id = 0; id < nameList.length; ++id) {
                    if (nameList[id] == null) continue;
                    ps.printf("canonicalIdByName.put(\"%s\", %d);\n", nameList[id], id);
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(ps);
                    throw throwable;
                }
                MCPatcherUtils.close(ps);
            }
            MCPatcherUtils.close(ps);
        }
    }

    public static Block getFixedBlock(String name) {
        Block block = BlockAPI.parseBlockName(name);
        if (block == null) {
            new IllegalArgumentException("unknown block " + name).printStackTrace();
        }
        return block;
    }

    public static Block parseBlockName(String name) {
        return (Block)GameData.getBlockRegistry().func_82594_a(name);
    }

    public static String getBlockName(Block block) {
        return block == null ? "(null)" : block.func_149739_a();
    }

    public static List<Block> getAllBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block block : GameData.getBlockRegistry().typeSafeIterable()) {
            if (block == null || blocks.contains(block)) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public static Block getBlockAt(IBlockAccess blockAccess, int i, int j, int k) {
        return blockAccess.func_147439_a(i, j, k);
    }

    public static int getMetadataAt(IBlockAccess blockAccess, int i, int j, int k) {
        return blockAccess.func_72805_g(i, j, k);
    }

    public static IIcon getBlockIcon(Block block, IBlockAccess blockAccess, int i, int j, int k, int face) {
        return block.func_149673_e(blockAccess, i, j, k, face);
    }

    public static boolean shouldSideBeRendered(Block block, IBlockAccess blockAccess, int i, int j, int k, int face) {
        return block.func_149646_a(blockAccess, i, j, k, face);
    }

    public static int getBlockLightValue(Block block) {
        return block.func_149750_m();
    }

    public static BlockStateMatcher createMatcher(PropertiesFile source, String matchString) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        String namespace = null;
        String blockName = null;
        StringBuilder metadata = new StringBuilder();
        StringBuilder metaString = new StringBuilder();
        for (String s : matchString.split("\\s*:\\s*")) {
            if (s.isEmpty()) continue;
            boolean appendThis = false;
            String[] tokens = s.split("\\s*=\\s*", 2);
            if (blockName == null) {
                blockName = s;
            } else if (tokens.length == 2) {
                propertyMap.put(tokens[0], tokens[1]);
                appendThis = true;
            } else if (namespace == null && !s.matches("\\d[-, 0-9]*")) {
                namespace = blockName;
                blockName = s;
            } else if (s.matches("\\d[-, 0-9]*")) {
                metadata.append(' ').append(s);
                appendThis = true;
            } else {
                source.warning("invalid token '%s' in %s", source, s, matchString);
                return null;
            }
            if (!appendThis) continue;
            metaString.append(':');
            metaString.append(s);
        }
        if (MCPatcherUtils.isNullOrEmpty(namespace)) {
            namespace = source.getResource().func_110624_b();
        }
        if (MCPatcherUtils.isNullOrEmpty(blockName)) {
            source.warning("cannot parse namespace/block name from %s", matchString);
            return null;
        }
        Block block = BlockAPI.parseBlockName(namespace + ':' + blockName);
        if (block == null) {
            source.warning("unknown block %s:%s", namespace, blockName);
            return null;
        }
        return new BlockStateMatcher(metaString.toString(), block, metadata.toString().trim());
    }
}

