/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.api;

import io.netty.buffer.ByteBuf;

public class DisplaySettingHelper {
    private String settings = "0";
    private boolean all_true = false;

    public DisplaySettingHelper() {
    }

    public DisplaySettingHelper(boolean all_true) {
        this.all_true = all_true;
    }

    public DisplaySettingHelper(String settings) {
        this.settings = this.sanitizeSettings(settings);
    }

    public DisplaySettingHelper(int legacySettings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 31; i >= 0; --i) {
            sb.append((legacySettings >>> i & 1) == 1 ? "1" : "0");
        }
        this.settings = sb.reverse().toString();
    }

    public DisplaySettingHelper(ByteBuf buf) {
        short length = buf.readShort();
        int bytesToRead = (length + 7) / 8;
        StringBuilder sb = new StringBuilder(bytesToRead * 8);
        for (int i = 0; i < bytesToRead; ++i) {
            byte value = buf.readByte();
            sb.append(String.format("%8s", Integer.toBinaryString(value & 0xFF)).replace(' ', '0'));
        }
        this.settings = sb.substring(0, length);
    }

    public DisplaySettingHelper(DisplaySettingHelper helper) {
        this.settings = helper.settings;
        this.all_true = helper.all_true;
    }

    public boolean getSetting(int bitMask) {
        return this.getNewSetting(DisplaySettingHelper.bitMaskToIndex(bitMask));
    }

    public boolean getNewSetting(int index) {
        if (this.all_true) {
            return true;
        }
        if (index >= 0 && index < this.settings.length()) {
            return this.settings.charAt(index) == '1';
        }
        return false;
    }

    public int addSetting(boolean value) {
        this.settings = this.settings + (value ? (char)'1' : '0');
        return this.settings.length() - 1;
    }

    public int getAsInteger() {
        if (this.all_true) {
            return Integer.MAX_VALUE;
        }
        String s = new StringBuilder(this.settings.substring(0, Math.min(31, this.settings.length()))).reverse().toString();
        return Integer.parseInt(s, 2);
    }

    public void writeToByteBuffer(ByteBuf buf) {
        if (!this.settings.matches("[01]+")) {
            this.settings = this.sanitizeSettings(this.settings);
        }
        buf.writeShort(this.settings.length());
        int remainder = this.settings.length() % 8;
        if (remainder != 0) {
            int padding = 8 - remainder;
            StringBuilder sb = new StringBuilder(this.settings.length() + padding);
            sb.append(this.settings);
            for (int i = 0; i < padding; ++i) {
                sb.append('0');
            }
            this.settings = sb.toString();
        }
        for (int i = 0; i < this.settings.length(); i += 8) {
            String byteString = this.settings.substring(i, i + 8);
            byte value = (byte)Integer.parseInt(byteString, 2);
            buf.writeByte((int)value);
        }
    }

    public String toString() {
        return this.settings;
    }

    private void setSetting(int index, boolean value) {
        StringBuilder sb = new StringBuilder(this.settings);
        if (this.settings.length() > index) {
            sb.setCharAt(index, value ? (char)'1' : '0');
        } else {
            while (sb.length() < index) {
                sb.append('0');
            }
            sb.append(value ? (char)'1' : '0');
        }
        this.settings = sb.toString();
    }

    public void toggleSetting(int index) {
        this.setSetting(index, !this.getNewSetting(index));
    }

    public static int indexToBitMask(int value) {
        return 1 << value;
    }

    public static int bitMaskToIndex(int value) {
        return Integer.numberOfTrailingZeros(value);
    }

    private String sanitizeSettings(String input) {
        if (input == null || input.isEmpty()) {
            return "0";
        }
        if (input.matches("[01]+")) {
            return input;
        }
        try {
            int legacy = Integer.parseInt(input);
            StringBuilder sb = new StringBuilder();
            for (int i = 31; i >= 0; --i) {
                sb.append((legacy >>> i & 1) == 1 ? "1" : "0");
            }
            return sb.reverse().toString();
        }
        catch (NumberFormatException e) {
            return "0";
        }
    }
}

