/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.client.gui;

import com.projecturanus.betterp2p.BetterP2P;
import com.projecturanus.betterp2p.client.gui.InfoWrapperKt;
import com.projecturanus.betterp2p.network.data.P2PInfo;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.util.p2p.ClientTunnelInfo;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.UStringsKt;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010@\u001a\u00020\u0018H\u0016J\u0013\u0010A\u001a\u00020\u000e2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b&\u0010$R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001d\u0010-\u001a\u0004\u0018\u00010\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010(\u001a\u0004\b.\u0010$R\u001a\u00100\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010$\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0010\"\u0004\b6\u00107R\u0011\u00108\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010;R\u0011\u0010>\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010;\u00a8\u0006C"}, d2={"Lcom/projecturanus/betterp2p/client/gui/InfoWrapper;", "", "info", "Lcom/projecturanus/betterp2p/network/data/P2PInfo;", "<init>", "(Lcom/projecturanus/betterp2p/network/data/P2PInfo;)V", "value", "", "frequency", "getFrequency", "()J", "setFrequency", "(J)V", "hasChannel", "", "getHasChannel", "()Z", "loc", "Lcom/projecturanus/betterp2p/network/data/P2PLocation;", "getLoc", "()Lcom/projecturanus/betterp2p/network/data/P2PLocation;", "output", "getOutput", "type", "", "getType", "()I", "icon", "Lnet/minecraft/util/IIcon;", "getIcon", "()Lnet/minecraft/util/IIcon;", "overlay", "getOverlay", "description", "", "getDescription", "()Ljava/lang/String;", "freqDisplay", "getFreqDisplay", "freqDisplay$delegate", "Lkotlin/Lazy;", "hoverInfo", "", "getHoverInfo", "()Ljava/util/List;", "channels", "getChannels", "channels$delegate", "name", "getName", "setName", "(Ljava/lang/String;)V", "error", "getError", "setError", "(Z)V", "bindButton", "Lnet/minecraft/client/gui/GuiButton;", "getBindButton", "()Lnet/minecraft/client/gui/GuiButton;", "renameButton", "getRenameButton", "unbindButton", "getUnbindButton", "hashCode", "equals", "other", "betterp2p"})
public final class InfoWrapper {
    private long frequency;
    private final boolean hasChannel;
    @NotNull
    private final P2PLocation loc;
    private final boolean output;
    private final int type;
    @NotNull
    private final IIcon icon;
    @NotNull
    private final IIcon overlay;
    @NotNull
    private final String description;
    @NotNull
    private final Lazy freqDisplay$delegate;
    @NotNull
    private final List<String> hoverInfo;
    @NotNull
    private final Lazy channels$delegate;
    @NotNull
    private String name;
    private boolean error;
    @NotNull
    private final GuiButton bindButton;
    @NotNull
    private final GuiButton renameButton;
    @NotNull
    private final GuiButton unbindButton;

    public InfoWrapper(@NotNull P2PInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.frequency = info2.getFrequency();
        this.hasChannel = info2.getHasChannel();
        this.loc = new P2PLocation(info2.getPosX(), info2.getPosY(), info2.getPosZ(), info2.getFacing(), info2.getDim());
        this.output = info2.getOutput();
        this.type = info2.getType();
        this.freqDisplay$delegate = LazyKt.lazy(() -> InfoWrapper.freqDisplay_delegate$lambda$2(this));
        this.channels$delegate = LazyKt.lazy(() -> InfoWrapper.channels_delegate$lambda$3(info2));
        this.name = info2.getName();
        this.bindButton = new GuiButton(0, 0, 0, 34, 20, I18n.func_135052_a((String)"gui.advanced_memory_card.bind", (Object[])new Object[0]));
        this.renameButton = new GuiButton(0, 0, 0, 0, 0, "");
        this.unbindButton = new GuiButton(0, 0, 0, 34, 20, I18n.func_135052_a((String)"gui.advanced_memory_card.unbind", (Object[])new Object[0]));
        TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromIndex(info2.getType());
        Intrinsics.checkNotNull((Object)tunnelInfo, (String)"null cannot be cast to non-null type com.projecturanus.betterp2p.util.p2p.ClientTunnelInfo");
        ClientTunnelInfo p2pType = (ClientTunnelInfo)tunnelInfo;
        this.icon = (IIcon)p2pType.getIcon().invoke();
        this.overlay = p2pType.getStack().func_77954_c();
        Object[] objectArray = new Object[]{p2pType.getDispName(), this.output ? I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.output", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.input", (Object[])new Object[0])};
        this.description = I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.type", (Object[])objectArray);
        boolean online = info2.getHasChannel();
        Object[] objectArray2 = new String[4];
        objectArray2[0] = "\u00a7bP2P - " + p2pType.getDispName();
        Object[] objectArray3 = new Object[]{info2.getPosX(), info2.getPosY(), info2.getPosZ()};
        objectArray2[1] = "\u00a7e" + I18n.func_135052_a((String)"gui.advanced_memory_card.pos", (Object[])objectArray3);
        objectArray3 = new Object[]{info2.getFacing().name()};
        objectArray2[2] = "\u00a7e" + I18n.func_135052_a((String)"gui.advanced_memory_card.side", (Object[])objectArray3);
        objectArray3 = new Object[]{info2.getDim()};
        objectArray2[3] = "\u00a7e" + I18n.func_135052_a((String)"gui.advanced_memory_card.dim", (Object[])objectArray3);
        this.hoverInfo = CollectionsKt.mutableListOf((Object[])objectArray2);
        boolean bl = this.error || this.frequency == 0L ? this.hoverInfo.add("\u00a7c" + I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.unbound", (Object[])new Object[0])) : this.hoverInfo.add("\u00a7a" + I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.bound", (Object[])new Object[0]));
        if (!online) {
            this.hoverInfo.add("\u00a7c" + I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.offline", (Object[])new Object[0]));
        }
    }

    public final long getFrequency() {
        return this.frequency;
    }

    public final void setFrequency(long value) {
        if (this.error || value == 0L) {
            this.hoverInfo.set(4, "\u00a7c" + I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.unbound", (Object[])new Object[0]));
        } else {
            this.hoverInfo.set(4, "\u00a7a" + I18n.func_135052_a((String)"gui.advanced_memory_card.p2p_status.bound", (Object[])new Object[0]));
        }
        this.frequency = value;
    }

    public final boolean getHasChannel() {
        return this.hasChannel;
    }

    @NotNull
    public final P2PLocation getLoc() {
        return this.loc;
    }

    public final boolean getOutput() {
        return this.output;
    }

    public final int getType() {
        return this.type;
    }

    @NotNull
    public final IIcon getIcon() {
        return this.icon;
    }

    @NotNull
    public final IIcon getOverlay() {
        return this.overlay;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getFreqDisplay() {
        Lazy lazy = this.freqDisplay$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final List<String> getHoverInfo() {
        return this.hoverInfo;
    }

    @Nullable
    public final String getChannels() {
        Lazy lazy = this.channels$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final boolean getError() {
        return this.error;
    }

    public final void setError(boolean bl) {
        this.error = bl;
    }

    @NotNull
    public final GuiButton getBindButton() {
        return this.bindButton;
    }

    @NotNull
    public final GuiButton getRenameButton() {
        return this.renameButton;
    }

    @NotNull
    public final GuiButton getUnbindButton() {
        return this.unbindButton;
    }

    public int hashCode() {
        return this.loc.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.projecturanus.betterp2p.client.gui.InfoWrapper");
        InfoWrapper cfr_ignored_0 = (InfoWrapper)other;
        return Intrinsics.areEqual((Object)this.loc, (Object)((InfoWrapper)other).loc);
    }

    private static final String freqDisplay_delegate$lambda$2(InfoWrapper this$0) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241.append(I18n.func_135052_a((String)"item.advanced_memory_card.selected", (Object[])new Object[0]));
        $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241.append(" ");
        if (this$0.frequency != 0L) {
            StringBuilder stringBuilder3;
            StringBuilder $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241_u24lambda_u240 = stringBuilder3 = new StringBuilder();
            boolean bl2 = false;
            String string = UStringsKt.toString-V7xB4Y4((int)UInt.constructor-impl((int)((int)(this$0.frequency >> 32))), (int)16).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241_u24lambda_u240.append(string);
            String string2 = UStringsKt.toString-V7xB4Y4((int)UInt.constructor-impl((int)((int)this$0.frequency)), (int)16).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241_u24lambda_u240.append(string2);
            String hex = InfoWrapperKt.format4(stringBuilder3.toString());
            stringBuilder = $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241.append(hex);
        } else {
            stringBuilder = $this$freqDisplay_delegate_u24lambda_u242_u24lambda_u241.append(I18n.func_135052_a((String)"gui.advanced_memory_card.desc.not_set", (Object[])new Object[0]));
        }
        return stringBuilder2.toString();
    }

    private static final String channels_delegate$lambda$3(P2PInfo $info) {
        String string;
        if ($info.getChannels() >= 0) {
            Object[] objectArray = new Object[]{$info.getChannels()};
            string = I18n.func_135052_a((String)"gui.advanced_memory_card.extra.channel", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }
}

