/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.bytebuf;

import com.gtnewhorizon.gtnhlib.bytebuf.Checks;
import com.gtnewhorizon.gtnhlib.bytebuf.MemoryStack;
import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.bytebuf.Pointer;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = APIUtil.getDebugStream();
    private static final Pattern API_VERSION_PATTERN;

    private static PrintStream getDebugStream() {
        PrintStream debugStream = System.err;
        PrintStream state = System.err;
        if (state instanceof String) {
            try {
                Supplier factory = (Supplier)Class.forName((String)((Object)state)).getConstructor(new Class[0]).newInstance(new Object[0]);
                debugStream = (PrintStream)factory.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state instanceof Supplier) {
            debugStream = (PrintStream)((Supplier)((Object)state)).get();
        } else if (state instanceof PrintStream) {
            debugStream = state;
        }
        return debugStream;
    }

    private APIUtil() {
    }

    public static void apiLog(CharSequence msg) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] " + msg + "\n");
        }
    }

    public static void apiLogMore(CharSequence msg) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("\t" + msg + "\n");
        }
    }

    public static void apiLogMissing(String api, ByteBuffer functionName) {
        if (Checks.DEBUG) {
            String function = MemoryUtilities.memASCII(functionName, functionName.remaining() - 1);
            DEBUG_STREAM.print("[LWJGL] Failed to locate address for " + api + " function " + function + "\n");
        }
    }

    @Nullable
    public static ByteBuffer apiGetMappedBuffer(@Nullable ByteBuffer buffer, long mappedAddress, int capacity) {
        if (buffer != null && MemoryUtilities.memAddress(buffer) == mappedAddress && buffer.capacity() == capacity) {
            return buffer;
        }
        return mappedAddress == 0L ? null : MemoryUtilities.wrapBufferByte(mappedAddress, capacity);
    }

    public static long apiGetBytes(int elements, int elementShift) {
        return ((long)elements & 0xFFFFFFFFL) << elementShift;
    }

    public static long apiCheckAllocation(int elements, long bytes, long maxBytes) {
        if (Checks.DEBUG) {
            if (elements < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (maxBytes + Long.MIN_VALUE < bytes + Long.MIN_VALUE) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return bytes;
    }

    @Nullable
    public static APIVersion apiParseVersion(Object option) {
        Object state = option;
        APIVersion version = state instanceof String ? APIUtil.apiParseVersion((String)state) : (state instanceof APIVersion ? (APIVersion)state : null);
        return version;
    }

    public static APIVersion apiParseVersion(String version) {
        Matcher matcher = API_VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", version));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static String apiUnknownToken(int token) {
        return APIUtil.apiUnknownToken("Unknown", token);
    }

    public static String apiUnknownToken(String description, int token) {
        return String.format("%s [0x%X]", description, token);
    }

    public static Map<Integer, String> apiClassTokens(@Nullable BiPredicate<Field, Integer> filter, @Nullable Map<Integer, String> target, Class<?> ... tokenClasses) {
        if (target == null) {
            target = new HashMap<Integer, String>(64);
        }
        int TOKEN_MODIFIERS = 25;
        for (Class<?> tokenClass : tokenClasses) {
            for (Field field : tokenClass.getDeclaredFields()) {
                if ((field.getModifiers() & TOKEN_MODIFIERS) != TOKEN_MODIFIERS || field.getType() != Integer.TYPE) continue;
                try {
                    Integer value = field.getInt(null);
                    if (filter != null && !filter.test(field, value)) continue;
                    String name = target.get(value);
                    target.put(value, name == null ? field.getName() : name + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return target;
    }

    public static long apiArray(MemoryStack stack, long ... addresses) {
        PointerBuffer pointers = MemoryUtilities.memPointerBuffer(stack.nmalloc(MemoryStack.POINTER_SIZE, addresses.length << MemoryStack.POINTER_SHIFT), addresses.length);
        for (long address : addresses) {
            pointers.put(address);
        }
        return MemoryUtilities.memAddress(pointers);
    }

    public static long apiArray(MemoryStack stack, ByteBuffer ... buffers) {
        PointerBuffer pointers = MemoryUtilities.memPointerBuffer(stack.nmalloc(MemoryStack.POINTER_SIZE, buffers.length << MemoryStack.POINTER_SHIFT), buffers.length);
        for (ByteBuffer buffer : buffers) {
            pointers.put(MemoryUtilities.memAddress(buffer));
        }
        return MemoryUtilities.memAddress(pointers);
    }

    public static long apiArrayp(MemoryStack stack, ByteBuffer ... buffers) {
        long pointers = APIUtil.apiArray(stack, buffers);
        PointerBuffer lengths = stack.mallocPointer(buffers.length);
        for (ByteBuffer buffer : buffers) {
            lengths.put((long)buffer.remaining());
        }
        return pointers;
    }

    public static long apiArray(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        for (CharSequence s : strings) {
            pointers.put(MemoryUtilities.memAddress(encoder.encode(s, true)));
        }
        return MemoryUtilities.memAddress(pointers);
    }

    public static long apiArrayi(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        IntBuffer lengths = stack.mallocInt(strings.length);
        for (CharSequence s : strings) {
            ByteBuffer buffer = encoder.encode(s, false);
            pointers.put(MemoryUtilities.memAddress(buffer));
            lengths.put(buffer.capacity());
        }
        return MemoryUtilities.memAddress(pointers);
    }

    public static long apiArrayp(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        PointerBuffer lengths = stack.mallocPointer(strings.length);
        for (CharSequence s : strings) {
            ByteBuffer buffer = encoder.encode(s, false);
            pointers.put(MemoryUtilities.memAddress(buffer));
            lengths.put((long)buffer.capacity());
        }
        return MemoryUtilities.memAddress(pointers);
    }

    public static void apiArrayFree(long pointers, int length) {
        int i = length;
        while (--i >= 0) {
            MemoryUtilities.nmemFree(MemoryUtilities.memGetAddress(pointers + Integer.toUnsignedLong(i) * (long)Pointer.POINTER_SIZE));
        }
    }

    public static void apiClosureRet(long ret, boolean __result) {
        MemoryUtilities.memPutAddress(ret, __result ? 1L : 0L);
    }

    public static void apiClosureRet(long ret, byte __result) {
        MemoryUtilities.memPutAddress(ret, (long)__result & 0xFFL);
    }

    public static void apiClosureRet(long ret, short __result) {
        MemoryUtilities.memPutAddress(ret, (long)__result & 0xFFFFL);
    }

    public static void apiClosureRet(long ret, int __result) {
        MemoryUtilities.memPutAddress(ret, (long)__result & 0xFFFFFFFFL);
    }

    public static void apiClosureRetL(long ret, long __result) {
        MemoryUtilities.memPutLong(ret, __result);
    }

    public static void apiClosureRetP(long ret, long __result) {
        MemoryUtilities.memPutAddress(ret, __result);
    }

    public static void apiClosureRet(long ret, float __result) {
        MemoryUtilities.memPutFloat(ret, __result);
    }

    public static void apiClosureRet(long ret, double __result) {
        MemoryUtilities.memPutDouble(ret, __result);
    }

    static {
        String PREFIX = "[^\\d\\n\\r]*";
        String VERSION = "(\\d+)[.](\\d+)(?:[.](\\S+))?";
        String IMPLEMENTATION = "(?:\\s+(.+?))?\\s*";
        API_VERSION_PATTERN = Pattern.compile("^" + PREFIX + VERSION + IMPLEMENTATION + "$", 32);
    }

    public static class APIVersion
    implements Comparable<APIVersion> {
        public final int major;
        public final int minor;
        @Nullable
        public final String revision;
        @Nullable
        public final String implementation;

        public APIVersion(int major, int minor) {
            this(major, minor, null, null);
        }

        public APIVersion(int major, int minor, @Nullable String revision, @Nullable String implementation) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.implementation = implementation;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(16);
            sb.append(this.major).append('.').append(this.minor);
            if (this.revision != null) {
                sb.append('.').append(this.revision);
            }
            if (this.implementation != null) {
                sb.append(" (").append(this.implementation).append(')');
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof APIVersion)) {
                return false;
            }
            APIVersion that = (APIVersion)o;
            return this.major == that.major && this.minor == that.major && Objects.equals(this.revision, that.revision) && Objects.equals(this.implementation, that.implementation);
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
            result = 31 * result + (this.implementation != null ? this.implementation.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(APIVersion other) {
            if (this.major != other.major) {
                return Integer.compare(this.major, other.major);
            }
            if (this.minor != other.minor) {
                return Integer.compare(this.minor, other.minor);
            }
            return 0;
        }
    }

    public static interface Encoder {
        public ByteBuffer encode(CharSequence var1, boolean var2);
    }
}

