/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine.transmission;

import binnie.core.machines.Machine;
import binnie.extrabees.apiary.ComponentBeeModifier;
import binnie.extrabees.apiary.TileExtraBeeAlveary;
import cofh.api.energy.IEnergyHandler;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TransmissionModifierComponent
extends ComponentBeeModifier
implements IBeeModifier,
IBeeListener {
    public TransmissionModifierComponent(Machine machine) {
        super(machine);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int energy = this.getUtil().getPoweredMachine().getEnergyStored(ForgeDirection.NORTH);
        if (energy == 0) {
            return;
        }
        TileExtraBeeAlveary tile = (TileExtraBeeAlveary)this.getMachine().getTileEntity();
        ArrayList<IEnergyHandler> handlers = new ArrayList<IEnergyHandler>();
        for (TileEntity alvearyTile : tile.getAlvearyBlocks()) {
            if (!(alvearyTile instanceof IEnergyHandler) || alvearyTile == tile) continue;
            handlers.add((IEnergyHandler)alvearyTile);
        }
        if (handlers.isEmpty()) {
            return;
        }
        int maxOutput = 500;
        int output = energy / handlers.size();
        if (output > maxOutput) {
            output = maxOutput;
        } else if (output < 1) {
            output = 1;
        }
        for (IEnergyHandler handler : handlers) {
            int received = handler.receiveEnergy(ForgeDirection.NORTH, output, false);
            this.getUtil().getPoweredMachine().receiveEnergy(ForgeDirection.NORTH, -received, false);
            energy = this.getUtil().getPoweredMachine().getEnergyStored(ForgeDirection.NORTH);
            if (energy > 0) continue;
            return;
        }
    }
}

