/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util.structurelib;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import cpw.mods.fml.common.FMLLog;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fuzzycraft.botanichorizons.util.BlockPos;
import net.fuzzycraft.botanichorizons.util.structurelib.HoloProjectorSupport;
import net.fuzzycraft.botanichorizons.util.structurelib.HoloScanner;
import net.fuzzycraft.botanichorizons.util.structurelib.extraction.InMemoryWorld;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class HoloExtractor {
    @Nonnull
    private final World serverWorld;
    @Nonnull
    private final TileEntity serverTileEntity;
    @Nonnull
    private final World shadowWorld;
    @Nonnull
    private final TileEntity shadowTileEntity;
    @Nonnull
    private final BlockPos coordinates;

    public HoloExtractor(@Nonnull World serverWorld, @Nonnull TileEntity serverTileEntity, @Nonnull World shadowWorld, @Nonnull TileEntity shadowTileEntity, @Nonnull BlockPos coordinates) {
        this.serverWorld = serverWorld;
        this.serverTileEntity = serverTileEntity;
        this.shadowWorld = shadowWorld;
        this.shadowTileEntity = shadowTileEntity;
        this.coordinates = coordinates;
    }

    @Nullable
    public HoloScanner getScanner(int side) {
        IConstructable constructable = HoloExtractor.getConstructable(this.shadowTileEntity, side);
        if (constructable == null) {
            return null;
        }
        return new HoloScanner(constructable, this.shadowWorld);
    }

    @Nullable
    public static HoloExtractor wrapExtractor(@Nonnull TileEntity tileEntity) {
        TileEntity shadowEntity;
        World serverWorld = tileEntity.func_145831_w();
        BlockPos coordinates = new BlockPos(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        Block block = serverWorld.func_147439_a(coordinates.x, coordinates.y, coordinates.z);
        int blockMeta = serverWorld.func_72805_g(coordinates.x, coordinates.y, coordinates.z);
        InMemoryWorld shadowWorld = new InMemoryWorld();
        shadowWorld.field_72995_K = true;
        NBTTagCompound copy = new NBTTagCompound();
        tileEntity.func_145841_b(copy);
        try {
            shadowWorld.func_147465_d(coordinates.x, coordinates.y, coordinates.z, block, blockMeta, 0);
            shadowEntity = block.createTileEntity((World)shadowWorld, blockMeta);
            shadowWorld.func_147455_a(coordinates.x, coordinates.y, coordinates.z, shadowEntity);
            shadowEntity.func_145839_a(copy);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.WARN, (Throwable)e, (String)"Could not extract tile entity to a dummy world: %s at %d, %d, %d", (Object[])new Object[]{tileEntity.getClass().getName(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e});
            return null;
        }
        return new HoloExtractor(serverWorld, tileEntity, shadowWorld, shadowEntity, coordinates);
    }

    @Nullable
    public static HoloScanner scanTileEntity(@Nonnull TileEntity tileEntity, int side) {
        if (!HoloExtractor.isProbablyConstructable(tileEntity)) {
            return null;
        }
        HoloExtractor extractor = HoloExtractor.wrapExtractor(tileEntity);
        if (extractor == null) {
            return null;
        }
        try {
            HoloScanner scanner = extractor.getScanner(side);
            if (scanner == null) {
                return null;
            }
            if (scanner.multiblockLocations.isEmpty()) {
                FMLLog.log((Level)Level.WARN, (String)"Scanning yielded no results: %s at %d, %d, %d", (Object[])new Object[]{tileEntity.getClass().getName(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e});
                return null;
            }
            return scanner;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.WARN, (Throwable)e, (String)"Scanning for hologram failed: %s at %d, %d, %d", (Object[])new Object[]{tileEntity.getClass().getName(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e});
            return null;
        }
    }

    public static boolean isProbablyConstructable(TileEntity tileEntity) {
        if (tileEntity instanceof IConstructable) {
            return true;
        }
        if (tileEntity instanceof IConstructableProvider) {
            return true;
        }
        return IMultiblockInfoContainer.get(tileEntity.getClass()) != null;
    }

    @Nullable
    public static IConstructable getConstructable(TileEntity tileEntity, int side) {
        if (tileEntity instanceof IConstructable) {
            return (IConstructable)tileEntity;
        }
        if (tileEntity instanceof IConstructableProvider) {
            return ((IConstructableProvider)tileEntity).getConstructable();
        }
        IMultiblockInfoContainer container = IMultiblockInfoContainer.get(tileEntity.getClass());
        if (container != null) {
            ExtendedFacing facing = HoloProjectorSupport.getExtendedFacingFromItemUse(tileEntity, side);
            return container.toConstructable((Object)tileEntity, facing);
        }
        return null;
    }
}

