/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon;

import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonDir;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElement;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementList;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementType;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonLayer;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RavagedDungeonGenerator {
    private final Random rand;
    private final byte width;
    private final byte height;
    private final List<TIntHashSet> blockedLocs = new ArrayList<TIntHashSet>(4);
    public final DungeonLayer[] layers;

    public RavagedDungeonGenerator(int width, int height, int layers, Random rand) {
        this.rand = rand;
        this.width = (byte)width;
        this.height = (byte)height;
        this.layers = new DungeonLayer[layers];
        for (int a = 0; a < layers; ++a) {
            this.blockedLocs.add(new TIntHashSet());
        }
    }

    public void blockLocation(int layer, int x, int y) {
        this.blockedLocs.get(layer).add(x + y * this.width);
    }

    public boolean generate() {
        int entranceX = -1;
        int entranceY = -1;
        int attemptLayer = 0;
        for (int layer = 0; layer < this.layers.length; ++layer) {
            while (++attemptLayer < 80) {
                DungeonLayer dung;
                block22: {
                    DungeonElement room;
                    DungeonElement hallway1;
                    int attempt;
                    boolean hasBlockRoom = false;
                    boolean hasSmallRoom = false;
                    dung = new DungeonLayer(this.width, this.height, this.blockedLocs.get(layer));
                    if (layer == 0) {
                        dung.createEntrance(this.rand.nextInt(this.width), this.rand.nextInt(this.height));
                    } else {
                        dung.createDescendBottom(entranceX, entranceY);
                    }
                    switch (layer) {
                        case 0: {
                            DungeonElementType.RoomCombo.setRoomWeights(25, 5, 0, 0);
                            break;
                        }
                        case 1: {
                            DungeonElementType.RoomCombo.setRoomWeights(25, 8, 2, 1);
                            break;
                        }
                        case 2: {
                            DungeonElementType.RoomCombo.setRoomWeights(25, 9, 2, 3);
                            break;
                        }
                    }
                    DungeonElementList elements = dung.getElements();
                    for (int iteration = 0; iteration < 1 + Math.min(this.rand.nextInt(5), 3); ++iteration) {
                        int attempts = 18 + this.rand.nextInt(10);
                        for (attempt = 0; attempt < attempts; ++attempt) {
                            DungeonElement element;
                            int test = 0;
                            DungeonDir dir = DungeonDir.random(this.rand);
                            do {
                                int blocks;
                                DungeonDir nextDir;
                                int pathLength = this.rand.nextInt(3) + this.rand.nextInt(2) * this.rand.nextInt(2 + this.rand.nextInt(3));
                                for (int path = 0; path < pathLength && dung.addHallway(dir); ++path) {
                                    test = 0;
                                }
                                DungeonDir dungeonDir = test > 0 ? DungeonDir.random(this.rand) : (nextDir = this.rand.nextBoolean() ? dir.rotatedLeft() : dir.rotatedRight());
                                if (this.rand.nextFloat() > 0.78f && dung.canGenerateRoom(dir) && (blocks = dung.addRoom(dir, this.rand)) > 0) {
                                    if (blocks == 1) {
                                        hasSmallRoom = true;
                                    } else if (blocks == 4) {
                                        hasBlockRoom = true;
                                    }
                                    test = 0;
                                    if (this.rand.nextInt(4) == 0) break;
                                    nextDir = DungeonDir.random(this.rand);
                                    if (nextDir == dir.reversed()) {
                                        nextDir = DungeonDir.random(this.rand);
                                    }
                                }
                                dir = nextDir;
                            } while (++test <= 4);
                            if ((element = elements.getRandom(this.rand.nextFloat() < 0.22f ? DungeonElementType.ROOM : DungeonElementType.HALLWAY, this.rand)) == null) break;
                            dung.moveToElement(element);
                        }
                        dung.moveToEntrance();
                    }
                    block11: for (attempt = 0; attempt < 15 && (hallway1 = elements.getRandom(DungeonElementType.HALLWAY, this.rand)) != null; ++attempt) {
                        for (int dirAttempt = 0; dirAttempt < 4; ++dirAttempt) {
                            DungeonDir checkDir = DungeonDir.values[this.rand.nextInt(DungeonDir.values.length)];
                            DungeonElement hallway2 = elements.getAt(hallway1.x + checkDir.addX, hallway1.y + checkDir.addY);
                            if (hallway2 == null) continue;
                            hallway1.connect(checkDir);
                            hallway2.connect(checkDir.reversed());
                            continue block11;
                        }
                    }
                    List<DungeonElement> rooms = elements.getAll(DungeonElementType.ROOM);
                    if (rooms.size() < 7 || layer < this.layers.length - 1 && !hasSmallRoom || layer == this.layers.length - 1 && !hasBlockRoom) continue;
                    while (true) {
                        room = rooms.get(this.rand.nextInt(rooms.size()));
                        int groupSize = elements.getGrouped(room).size();
                        if (layer < this.layers.length - 1) {
                            if (groupSize != 1) continue;
                            entranceX = room.x;
                            entranceY = room.y;
                            dung.createDescend(room.x, room.y);
                            break block22;
                        }
                        if (layer != this.layers.length - 1) break block22;
                        if (groupSize == 4) break;
                    }
                    dung.createEnd(room.x, room.y);
                }
                this.layers[layer] = dung;
                break;
            }
            if (attemptLayer < 80) continue;
            return false;
        }
        return true;
    }
}

