/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.network.Packet;
import io.netty.buffer.ByteBuf;

public abstract class PacketUpdate
extends Packet {
    public ByteBuf stream;
    public ISerializable payload;
    private int packetId;

    public PacketUpdate() {
    }

    public PacketUpdate(int packetId, ISerializable payload) {
        this(packetId);
        this.payload = payload;
    }

    public PacketUpdate(int packetId) {
        this.packetId = packetId;
        this.isChunkDataPacket = true;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.packetId);
        this.writeIdentificationData(data);
        if (this.payload != null) {
            this.payload.writeData(data);
        }
    }

    public abstract void writeIdentificationData(ByteBuf var1);

    @Override
    public void readData(ByteBuf data) {
        this.packetId = data.readByte();
        this.readIdentificationData(data);
        this.stream = data;
    }

    public abstract void readIdentificationData(ByteBuf var1);

    @Override
    public int getID() {
        return this.packetId;
    }
}

