/*
 * Decompiled with CFR 0.152.
 */
package tectech.rendering.EOH;

import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import tectech.rendering.EOH.EOHRenderingUtils;
import tectech.thing.block.TileEntityEyeOfHarmony;

public class EOHTileEntitySR
extends TileEntitySpecialRenderer {
    public static final ResourceLocation STAR_LAYER_0 = new ResourceLocation("tectech", "models/StarLayer0.png");
    public static final ResourceLocation STAR_LAYER_1 = new ResourceLocation("tectech", "models/StarLayer1.png");
    public static final ResourceLocation STAR_LAYER_2 = new ResourceLocation("tectech", "models/StarLayer2.png");
    public static IModelCustom starModel;
    public static IModelCustom spaceModel;
    private static final float STAR_RESCALE = 0.2f;

    public EOHTileEntitySR() {
        starModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tectech", "models/Star.obj"));
        spaceModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tectech", "models/Space.obj"));
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!(tile instanceof TileEntityEyeOfHarmony)) {
            return;
        }
        TileEntityEyeOfHarmony EOHRenderTile = (TileEntityEyeOfHarmony)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        EOHRenderingUtils.renderOuterSpaceShell();
        this.renderOrbitObjects(EOHRenderTile);
        EOHRenderingUtils.renderStar(IItemRenderer.ItemRenderType.INVENTORY, 1);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderOrbitObjects(TileEntityEyeOfHarmony EOHRenderTile) {
        if (EOHRenderTile.getOrbitingObjects() != null) {
            if (EOHRenderTile.getOrbitingObjects().isEmpty()) {
                EOHRenderTile.generateImportantInfo();
            }
            for (TileEntityEyeOfHarmony.OrbitingObject t : EOHRenderTile.getOrbitingObjects()) {
                this.renderOrbit(EOHRenderTile, t);
            }
        }
    }

    void renderOrbit(TileEntityEyeOfHarmony EOHRenderTile, TileEntityEyeOfHarmony.OrbitingObject orbitingObject) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)orbitingObject.zAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)orbitingObject.xAngle, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(orbitingObject.rotationSpeed * 0.1f * EOHRenderTile.angle % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)(-0.2 - (double)orbitingObject.distance - (double)(0.2f * EOHRenderTile.getSize())), (double)0.0, (double)0.0);
        GL11.glRotatef((float)(orbitingObject.orbitSpeed * 0.1f * EOHRenderTile.angle % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(TextureMap.field_110575_b);
        EOHRenderingUtils.renderBlockInWorld(orbitingObject.block, 0, orbitingObject.scale);
        GL11.glPopMatrix();
    }
}

