/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity.recipe.beamline;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.material.MaterialsElements;
import gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.item.MaskList;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.register.WerkstoffMaterialPool;
import gtnhlanth.common.tileentity.recipe.beamline.SourceChamberMetadata;
import gtnhlanth.common.tileentity.recipe.beamline.TargetChamberMetadata;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BeamlineRecipeLoader {
    public static final HashMap<String, Fluid> coolantMap = new HashMap();
    private static final ItemList[] VIABLE_WAFERS = new ItemList[]{ItemList.Circuit_Silicon_Wafer, ItemList.Circuit_Silicon_Wafer2, ItemList.Circuit_Silicon_Wafer3, ItemList.Circuit_Silicon_Wafer4, ItemList.Circuit_Silicon_Wafer5, ItemList.Circuit_Silicon_Wafer6, ItemList.Circuit_Silicon_Wafer7};

    public static void load() {
        coolantMap.put(Materials.LiquidNitrogen.getGas(1L).getFluid().getName(), Materials.Nitrogen.getGas(1L).getFluid());
        coolantMap.put(Materials.LiquidOxygen.getGas(1L).getFluid().getName(), Materials.Oxygen.getGas(1L).getFluid());
        coolantMap.put("ic2coolant", FluidRegistry.getFluid((String)"ic2hotcoolant"));
        coolantMap.put(Materials.SuperCoolant.getFluid(1L).getFluid().getName(), WerkstoffMaterialPool.HotSuperCoolant.getFluidOrGas(1000).getFluid());
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.Tungsten, 1L)).metadata(LanthanidesRecipeMaps.SOURCE_CHAMBER_METADATA, SourceChamberMetadata.builder().particleID(Particle.ELECTRON.ordinal()).rate(20).energy(1000.0f, 0.1f).focus(98.0f).build()).duration(20).eut(TierEU.RECIPE_IV).addTo(LanthanidesRecipeMaps.sourceChamberRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffMaterialPool.LanthanumHexaboride.get(OrePrefixes.stickLong, 1)).metadata(LanthanidesRecipeMaps.SOURCE_CHAMBER_METADATA, SourceChamberMetadata.builder().particleID(Particle.ELECTRON.ordinal()).rate(60).energy(5000.0f, 0.3f).focus(99.0f).build()).duration(20).eut(TierEU.RECIPE_IV).addTo(LanthanidesRecipeMaps.sourceChamberRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsElements.getInstance().CALIFORNIUM.getDust(1)).metadata(LanthanidesRecipeMaps.SOURCE_CHAMBER_METADATA, SourceChamberMetadata.builder().particleID(Particle.NEUTRON.ordinal()).rate(10).energy(9000.0f, 999.0f).focus(95.0f).build()).duration(20).eut(TierEU.RECIPE_EV).addTo(LanthanidesRecipeMaps.sourceChamberRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.Uranium.getDust(1)).itemOutputs(WerkstoffMaterialPool.Thorium234.get(OrePrefixes.dust, 1)).metadata(LanthanidesRecipeMaps.SOURCE_CHAMBER_METADATA, SourceChamberMetadata.builder().particleID(Particle.ALPHA.ordinal()).rate(1).energy(4270.0f, 999.0f).focus(90.0f).build()).duration(20).eut(TierEU.RECIPE_HV).addTo(LanthanidesRecipeMaps.sourceChamberRecipes);
        for (MaskList mask : MaskList.values()) {
            if (mask.getProducedItem() == null) continue;
            if (mask.getTCTargetItem() == null) {
                int index = 0;
                for (ItemList wafer : VIABLE_WAFERS) {
                    ++index;
                    if (Arrays.asList(mask.getForbiddenWafers()).contains(wafer)) continue;
                    ItemStack focusItem = new ItemStack(LanthItemList.maskMap.get((Object)mask), 0);
                    GTValues.RA.stdBuilder().itemInputs(focusItem, wafer.get(1L, new Object[0])).itemOutputs(GTUtility.copyAmountUnsafe((int)GTUtility.powInt(2.0, index + 2), mask.getProducedItem())).metadata(LanthanidesRecipeMaps.TARGET_CHAMBER_METADATA, TargetChamberMetadata.builder(focusItem).particleID(1).amount((int)Math.round((double)mask.getBaselineAmount() * Math.sqrt(GTUtility.powInt(2.0, index - 1)))).energy(mask.getMinEnergy(), mask.getMaxEnergy(), 1.0f).minFocus(mask.getMinFocus()).build()).duration(1).eut(1920).addTo(LanthanidesRecipeMaps.targetChamberRecipes);
                }
                continue;
            }
            ItemStack focusItem = new ItemStack(LanthItemList.maskMap.get((Object)mask), 0);
            GTValues.RA.stdBuilder().itemInputs(focusItem, GTUtility.copyAmountUnsafe(1, mask.getTCTargetItem())).itemOutputs(GTUtility.copyAmountUnsafe(4, mask.getProducedItem())).metadata(LanthanidesRecipeMaps.TARGET_CHAMBER_METADATA, TargetChamberMetadata.builder(focusItem).particleID(1).amount(mask.getBaselineAmount()).energy(mask.getMinEnergy(), mask.getMaxEnergy(), 1.0f).minFocus(mask.getMinFocus()).build()).duration(1).eut(TierEU.RECIPE_LuV).addTo(LanthanidesRecipeMaps.targetChamberRecipes);
        }
        ItemStack focusItem = new ItemStack(LanthItemList.maskMap.get((Object)MaskList.CSOC), 0);
        GTValues.RA.stdBuilder().itemInputs(focusItem, WerkstoffMaterialPool.CeriumDopedLutetiumAluminiumGarnet.get(OrePrefixes.gemExquisite, 1)).itemOutputs(GTUtility.copyAmountUnsafe(64, ItemList.Circuit_Chip_CrystalSoC.get(1L, new Object[0]))).metadata(LanthanidesRecipeMaps.TARGET_CHAMBER_METADATA, TargetChamberMetadata.builder(focusItem).particleID(1).amount(24).energy(5.0f, 12.0f, 1.0f).minFocus(60.0f).build()).duration(1).eut(TierEU.RECIPE_LuV).addTo(LanthanidesRecipeMaps.targetChamberRecipes);
    }
}

