/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tools;

import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.common.items.behaviors.BehaviourNone;
import gregtech.common.tools.GTTool;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtTools;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ToolAngleGrinder
extends GTTool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityIronGolem.class.getName(), "EntityTowerGuardian");

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(".") + 1)) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 400;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 100;
    }

    @Override
    public float getBaseDamage() {
        return 8.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 2.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.8f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.GTCEU_OP_FILE.toString();
    }

    @Override
    public String getEntityHitSound() {
        return SoundResource.GTCEU_OP_FILE.toString();
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, int aMetaData) {
        String tTool = aBlock.getHarvestTool(aMetaData);
        return tTool != null && (tTool.equals("sword") || tTool.equals("file"));
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? TexturesGtTools.ANGLE_GRINDER : Textures.ItemIcons.POWER_UNIT_HV;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : Materials.TungstenSteel.mRGBa;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        aPlayer.func_71029_a((StatBase)AchievementList.field_76024_r);
        try {
            GTMod.achievements.issueAchievement(aPlayer, "tools");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " has been Ground out of existence by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }

    @Override
    public void onStatsAddedToTool(MetaGeneratedTool aItem, int aID) {
        aItem.addItemBehavior(aID, new BehaviourNone());
    }
}

