/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.powergoggles;

import appeng.api.util.DimensionalCoord;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.powergoggles.ItemPowerGoggles;
import kekztech.common.tileentities.MTELapotronicSuperCapacitor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class PowerGogglesUtil {
    public static boolean isLSC(TileEntity tileEntity) {
        IGregTechTileEntity te;
        return tileEntity instanceof IGregTechTileEntity && (te = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MTELapotronicSuperCapacitor;
    }

    public static ItemStack getPlayerGoggles(EntityPlayer player) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        for (ItemStack bauble : baubles.stackList) {
            if (bauble == null || !(bauble.func_77973_b() instanceof ItemPowerGoggles)) continue;
            return bauble;
        }
        return null;
    }

    public static boolean isPlayerWearingGoggles(EntityPlayer player) {
        return PowerGogglesUtil.getPlayerGoggles(player) != null;
    }

    public static MTELapotronicSuperCapacitor getLsc(DimensionalCoord lscLink) {
        if (lscLink == null) {
            return null;
        }
        WorldServer lscDim = MinecraftServer.func_71276_C().func_71218_a(lscLink.getDimension());
        if (lscDim == null) {
            return null;
        }
        TileEntity tileEntity = lscDim.func_147438_o(lscLink.x, lscLink.y, lscLink.z);
        if (tileEntity == null) {
            return null;
        }
        if (!PowerGogglesUtil.isLSC(tileEntity)) {
            return null;
        }
        return (MTELapotronicSuperCapacitor)((IGregTechTileEntity)tileEntity).getMetaTileEntity();
    }
}

