/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.objects.GTUOFluid;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.config.ConfigCategory;

public class GTUODimension {
    private final BiMap<String, GTUOFluid> fFluids = HashBiMap.create();
    private int maxChance;
    public String Dimension = "null";

    public GTUODimension(ConfigCategory aConfigCategory) {
        if (aConfigCategory.containsKey("Dimension")) {
            aConfigCategory.get((String)"Dimension").comment = "Dimension ID or Class Name";
            this.Dimension = aConfigCategory.get("Dimension").getString();
        }
        this.maxChance = 0;
        for (int i = 0; i < aConfigCategory.getChildren().size(); ++i) {
            GTUOFluid fluid = new GTUOFluid((ConfigCategory)aConfigCategory.getChildren().toArray()[i]);
            this.fFluids.put((Object)fluid.Registry, (Object)fluid);
            this.maxChance += fluid.Chance;
        }
    }

    public BiMap<String, GTUOFluid> getFluids() {
        return this.fFluids;
    }

    public GTUOFluid getRandomFluid(Random aRandom) {
        int random = aRandom.nextInt(1000);
        for (Map.Entry fl : this.fFluids.entrySet()) {
            int chance = ((GTUOFluid)fl.getValue()).Chance * 1000 / this.maxChance;
            if (random <= chance) {
                return (GTUOFluid)fl.getValue();
            }
            random -= chance;
        }
        return null;
    }

    public String getUOFluidKey(GTUOFluid uoFluid) {
        return (String)this.fFluids.inverse().get((Object)uoFluid);
    }

    public GTUOFluid getUOFluid(String key) {
        return (GTUOFluid)this.fFluids.get((Object)key);
    }
}

