/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class GTPacketSound
extends GTPacket {
    private double mX;
    private double mY;
    private double mZ;
    private String mSoundName;
    private float mSoundStrength;
    private float mSoundPitch;

    public GTPacketSound() {
    }

    public GTPacketSound(String aSoundName, float aSoundStrength, float aSoundPitch, double aX, double aY, double aZ) {
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mSoundName = aSoundName;
        this.mSoundStrength = aSoundStrength;
        this.mSoundPitch = aSoundPitch;
    }

    @Override
    public void encode(ByteBuf aOut) {
        try (ByteBufOutputStream byteOutputStream = new ByteBufOutputStream(aOut);){
            byteOutputStream.writeUTF(this.mSoundName);
            byteOutputStream.writeFloat(this.mSoundStrength);
            byteOutputStream.writeFloat(this.mSoundPitch);
            byteOutputStream.writeDouble(this.mX);
            byteOutputStream.writeDouble(this.mY);
            byteOutputStream.writeDouble(this.mZ);
        }
        catch (IOException e) {
            e.printStackTrace(GTLog.err);
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        return new GTPacketSound(aData.readUTF(), aData.readFloat(), aData.readFloat(), aData.readDouble(), aData.readDouble(), aData.readDouble());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (this.mSoundName != null) {
            GTUtility.doSoundAtClient(new ResourceLocation(this.mSoundName), 1, this.mSoundStrength, this.mSoundPitch, this.mX, this.mY, this.mZ);
        }
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.SOUND.id;
    }
}

