/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API;

import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BioVatLogicAdder {

    public static class MaterialSvPair {
        final Materials materials;
        final Integer sievert;

        public MaterialSvPair(Materials materials, Integer sievert) {
            this.materials = materials;
            this.sievert = sievert;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterialSvPair that = (MaterialSvPair)o;
            return Objects.equals(this.getMaterials(), that.getMaterials()) && Objects.equals(this.getSievert(), that.getSievert());
        }

        public int hashCode() {
            return Objects.hash(this.getMaterials(), this.getSievert());
        }

        public Materials getMaterials() {
            return this.materials;
        }

        public Integer getSievert() {
            return this.sievert;
        }
    }

    public static class RadioHatch {
        private static final HashSet<MaterialSvPair> MaSv = new HashSet();
        private static final HashMap<ItemStack, Integer> IsSv = new HashMap();
        private static final HashMap<ItemStack, Integer> IsKg = new HashMap();
        private static final HashMap<ItemStack, short[]> IsColor = new HashMap();
        public static int MaxSV = 150;

        public static void runBasicItemIntegration() {
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodThorium.get(1L, new Object[0]), Materials.Thorium, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodThorium2.get(1L, new Object[0]), Materials.Thorium, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodThorium4.get(1L, new Object[0]), Materials.Thorium, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadah.get(1L, new Object[0]), Materials.Naquadah, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadah2.get(1L, new Object[0]), Materials.Naquadah, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadah4.get(1L, new Object[0]), Materials.Naquadah, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodMOX.get(1L, new Object[0]), Materials.Plutonium, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodMOX2.get(1L, new Object[0]), Materials.Plutonium, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodMOX4.get(1L, new Object[0]), Materials.Plutonium, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodUranium.get(1L, new Object[0]), Materials.Uranium, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodUranium2.get(1L, new Object[0]), Materials.Uranium, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodUranium4.get(1L, new Object[0]), Materials.Uranium, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodTiberium.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodTiberium2.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodTiberium4.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadah32.get(1L, new Object[0]), Materials.Naquadah, 96);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodThorium.get(1L, new Object[0]), Materials.Thorium, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodThorium2.get(1L, new Object[0]), Materials.Thorium, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodThorium4.get(1L, new Object[0]), Materials.Thorium, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadah.get(1L, new Object[0]), Materials.Naquadah, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadah2.get(1L, new Object[0]), Materials.Naquadah, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadah4.get(1L, new Object[0]), Materials.Naquadah, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodMOX.get(1L, new Object[0]), Materials.Plutonium, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodMOX2.get(1L, new Object[0]), Materials.Plutonium, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodMOX4.get(1L, new Object[0]), Materials.Plutonium, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodUranium.get(1L, new Object[0]), Materials.Uranium, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodUranium2.get(1L, new Object[0]), Materials.Uranium, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodUranium4.get(1L, new Object[0]), Materials.Uranium, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodTiberium.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodTiberium2.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodTiberium4.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadah32.get(1L, new Object[0]), Materials.Naquadah, 96, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadria.get(1L, new Object[0]), Materials.Naquadria, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadria2.get(1L, new Object[0]), Materials.Naquadria, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.RodNaquadria4.get(1L, new Object[0]), Materials.Naquadria, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadria.get(1L, new Object[0]), Materials.Naquadria, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadria2.get(1L, new Object[0]), Materials.Naquadria, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.DepletedRodNaquadria4.get(1L, new Object[0]), Materials.Naquadria, 12, 10);
        }

        @NotNull
        public static HashSet<MaterialSvPair> getMaSv() {
            return MaSv;
        }

        @NotNull
        public static HashMap<ItemStack, Integer> getIsKg() {
            return IsKg;
        }

        @NotNull
        public static HashMap<ItemStack, Integer> getIsSv() {
            return IsSv;
        }

        @NotNull
        public static HashMap<ItemStack, short[]> getIsColor() {
            return IsColor;
        }

        public static void setOverrideSvForMaterial(Materials m, int sv) {
            MaSv.add(new MaterialSvPair(m, sv));
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, int sv) {
            IsSv.put(stack, sv);
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, Materials materials) {
            IsSv.put(stack, BWUtil.calculateSv(materials));
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, int sv, int kg) {
            IsSv.put(stack, sv);
            IsKg.put(stack, kg);
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, @NotNull Materials materials, int kg) {
            RadioHatch.giveItemStackRadioHatchAbilites(stack, BWUtil.calculateSv(materials), kg);
            IsColor.put(stack, materials.getRGBA());
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, @NotNull Materials materials, int kg, int divider) {
            RadioHatch.giveItemStackRadioHatchAbilites(stack, BWUtil.calculateSv(materials) / divider, kg);
            IsColor.put(stack, materials.getRGBA());
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, int sv, int kg, short[] color) {
            RadioHatch.giveItemStackRadioHatchAbilites(stack, sv, kg);
            IsColor.put(stack, color);
        }

        public static int getMaxSv() {
            int ret = MaxSV;
            for (MaterialSvPair pair : RadioHatch.getMaSv()) {
                if (pair.getSievert() <= ret) continue;
                ret = pair.getSievert();
            }
            for (ItemStack is : IsSv.keySet()) {
                if (IsSv.get(is) <= ret) continue;
                ret = IsSv.get(is);
            }
            return ret;
        }
    }
}

