/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.decorate;

import ganymedes01.etfuturum.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenTwistingVines
extends WorldGenerator {
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        if (WorldGenTwistingVines.isInvalidPlacementLocation(world, x, y, z)) {
            return false;
        }
        int spreadWidth = 8;
        int spreadHeight = 4;
        int maxHeight = 8;
        for (int l = 0; l < spreadWidth * spreadWidth; ++l) {
            int xOff = x + MathHelper.func_76136_a((Random)rand, (int)(-spreadWidth), (int)spreadWidth);
            int yOff = y + MathHelper.func_76136_a((Random)rand, (int)(-spreadHeight), (int)spreadHeight);
            int zOff = z + MathHelper.func_76136_a((Random)rand, (int)(-spreadWidth), (int)spreadWidth);
            while (--yOff <= 0 && world.func_147437_c(xOff, yOff + 1, zOff)) {
            }
            if (WorldGenTwistingVines.isInvalidPlacementLocation(world, xOff, ++yOff, zOff)) continue;
            int i1 = MathHelper.func_76136_a((Random)rand, (int)1, (int)maxHeight);
            if (rand.nextInt(6) == 0) {
                i1 *= 2;
            }
            if (rand.nextInt(5) == 0) {
                i1 = 1;
            }
            WorldGenTwistingVines.placeTwistingVinesColumn(world, rand, xOff, yOff, zOff, i1);
        }
        return true;
    }

    public static void placeTwistingVinesColumn(World world, Random rand, int x, int y, int z, int size) {
        for (int i = 0; i <= size; ++i) {
            if (!world.func_147437_c(x, y + i, z)) continue;
            if (i == size || !world.func_147437_c(x, y + i + 1, z)) {
                world.func_147465_d(x, y + i, z, ModBlocks.TWISTING_VINES.get(), 1, 2);
                break;
            }
            world.func_147449_b(x, y + i, z, ModBlocks.TWISTING_VINES.get());
        }
    }

    private static boolean isInvalidPlacementLocation(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        return !(block instanceof BlockNetherrack || block == ModBlocks.NYLIUM.get() && meta == 1 || block == ModBlocks.NETHER_WART.get() && meta == 1);
    }
}

