/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.client.particle.CustomParticles;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public interface IDegradable {
    public static final int CHECK_RANGE = 4;
    public static final String[] waxStrings = new String[]{"materialWax", "materialWaxcomb", "materialHoneycomb", "itemBeeswax"};

    public int getCopperMeta(int var1);

    default public int getCopperMeta(IBlockAccess world, int x, int y, int z, int meta) {
        return this.getCopperMeta(meta);
    }

    @Deprecated
    default public int getFinalCopperMeta(int meta, int worldMeta) {
        return this.getCopperMeta(meta);
    }

    default public int getFinalCopperMeta(IBlockAccess world, int x, int y, int z, int meta, int worldMeta) {
        return this.getCopperMeta(world, x, y, z, meta);
    }

    public Block getCopperBlockFromMeta(int var1);

    default public void tickDegradation(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && random.nextFloat() < 0.05688889f) {
            this.tryDegrade(world, x, y, z, random);
        }
    }

    default public boolean countTowardsDegredation(int meta, IBlockAccess world, int x, int y, int z) {
        return meta < 8;
    }

    default public void tryDegrade(World world, int x, int y, int z, Random random) {
        int i = this.getCopperMeta((IBlockAccess)world, x, y, z, world.func_72805_g(x, y, z));
        int j = 0;
        int k = 0;
        if (i < 7 && i % 4 != 3) {
            for (int x1 = -4; x1 <= 4; ++x1) {
                for (int y1 = -4; y1 <= 4; ++y1) {
                    for (int z1 = -4; z1 <= 4; ++z1) {
                        int m;
                        Block block = world.func_147439_a(x1 + x, y1 + y, z1 + z);
                        if (!(block instanceof IDegradable) || x1 == 0 && y1 == 0 && z1 == 0 || Math.abs(x1) + Math.abs(y1) + Math.abs(z1) > 4 || !this.countTowardsDegredation(m = ((IDegradable)block).getCopperMeta((IBlockAccess)world, x, y, z, world.func_72805_g(x1 + x, y1 + y, z1 + z)), (IBlockAccess)world, x + x1, y + y1, z + z1)) continue;
                        if ((m %= 4) < i % 4) {
                            return;
                        }
                        if (m > i % 4) {
                            ++k;
                            continue;
                        }
                        ++j;
                    }
                }
            }
            float f = (float)(k + 1) / (float)(k + j + 1);
            float g = f * f * (i % 4 == 0 ? 0.75f : 1.0f);
            if (random.nextFloat() < g) {
                this.setCopperBlock(this.getCopperBlockFromMeta(i + 1), this.getFinalCopperMeta((IBlockAccess)world, x, y, z, i + 1, world.func_72805_g(x, y, z)), world, x, y, z);
            }
        }
    }

    default public void setCopperBlock(Block newBlock, int newMeta, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, newBlock, newMeta, 2);
    }

    public static boolean isWaxableMaterial(ItemStack stack) {
        boolean slimeball = true;
        for (String waxString : waxStrings) {
            if (!OreDictionary.doesOreNameExist((String)waxString)) continue;
            slimeball = false;
            if (!EtFuturum.hasDictTag(stack, waxString)) continue;
            return true;
        }
        return slimeball && EtFuturum.hasDictTag(stack, "slimeball");
    }

    default public boolean tryWaxOnWaxOff(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        boolean flag = false;
        boolean flag2 = false;
        int meta = this.getCopperMeta((IBlockAccess)world, x, y, z, world.func_72805_g(x, y, z));
        if (entityPlayer.func_71045_bC() != null) {
            ItemStack heldStack = entityPlayer.func_71045_bC();
            if (meta < 8 && IDegradable.isWaxableMaterial(heldStack)) {
                flag = true;
                if (!entityPlayer.field_71075_bZ.field_75098_d && --heldStack.field_77994_a <= 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                entityPlayer.field_71069_bz.func_75142_b();
            }
            if (heldStack.func_77973_b().getToolClasses(heldStack).contains("axe") && (meta % 4 != 0 || meta > 7)) {
                heldStack.func_77972_a(1, (EntityLivingBase)entityPlayer);
                if (meta < 8) {
                    flag2 = true;
                } else {
                    flag = true;
                }
            }
            if (flag && !flag2) {
                int waxMeta = meta > 7 ? meta % 8 : meta % 8 + 8;
                Block block = this.getCopperBlockFromMeta(waxMeta);
                this.setCopperBlock(block, this.getFinalCopperMeta((IBlockAccess)world, x, y, z, waxMeta, world.func_72805_g(x, y, z)), world, x, y, z);
                this.spawnParticles(world, x, y, z, meta < 8 ? 0 : 1);
            } else if (!flag && flag2) {
                Block block = this.getCopperBlockFromMeta(meta - 1);
                this.setCopperBlock(block, this.getFinalCopperMeta((IBlockAccess)world, x, y, z, meta - 1, world.func_72805_g(x, y, z)), world, x, y, z);
                this.spawnParticles(world, x, y, z, 2);
            }
        }
        return flag || flag2;
    }

    default public void playSound(World world, double x, double y, double z, int type) {
        int pitch = world.field_73012_v.nextInt(3);
        world.func_72980_b(x, y, z, "minecraft_1.21:item." + (type == 0 ? "honeycomb.wax_on" : (type == 1 ? "axe.wax_off" : "axe.scrape")), 1.0f, (float)((pitch == 0 ? 0.0 : (double)pitch / 10.0) + 0.9), false);
    }

    default public void spawnParticles(World world, int x, int y, int z, int type) {
        if (world.field_72995_K) {
            Random random = world.field_73012_v;
            double d0 = 0.0625;
            this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, type);
            for (int l = 0; l < 10; ++l) {
                double d1 = (float)x + random.nextFloat();
                double d2 = (float)y + random.nextFloat();
                double d3 = (float)z + random.nextFloat();
                if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                    d2 = (double)(y + 1) + d0;
                }
                if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                    d2 = (double)y - d0;
                }
                if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                    d3 = (double)(z + 1) + d0;
                }
                if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                    d3 = (double)z - d0;
                }
                if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                    d1 = (double)(x + 1) + d0;
                }
                if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                    d1 = (double)x - d0;
                }
                if (!(d1 < (double)x || d1 > (double)(x + 1) || d2 < 0.0 || d2 > (double)(y + 1) || d3 < (double)z) && !(d3 > (double)(z + 1))) continue;
                if (type == 0) {
                    CustomParticles.spawnCopperWaxOnParticle(world, d1, d2, d3);
                    continue;
                }
                if (type == 1) {
                    CustomParticles.spawnCopperWaxOffParticle(world, d1, d2, d3);
                    continue;
                }
                CustomParticles.spawnCopperScrapeParticle(world, d1, d2, d3);
            }
        }
    }
}

