/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.visnet;

import cpw.mods.fml.common.FMLLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.World;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.TileVisNode;

public class VisNetHandler {
    static Method generateVisEffect;
    public static HashMap<Integer, HashMap<WorldCoordinates, WeakReference<TileVisNode>>> sources;
    private static HashMap<WorldCoordinates, ArrayList<WeakReference<TileVisNode>>> nearbyNodes;

    public static int drainVis(World world, int x, int y, int z, Aspect aspect, int amount) {
        ArrayList<WeakReference<TileVisNode>> nodes;
        int drainedAmount = 0;
        WorldCoordinates drainer = new WorldCoordinates(x, y, z, world.field_73011_w.field_76574_g);
        if (!nearbyNodes.containsKey(drainer)) {
            VisNetHandler.calculateNearbyNodes(world, x, y, z);
        }
        if ((nodes = nearbyNodes.get(drainer)) != null && nodes.size() > 0) {
            for (WeakReference<TileVisNode> noderef : nodes) {
                TileVisNode node = (TileVisNode)((Object)noderef.get());
                if (node == null) continue;
                int a = node.consumeVis(aspect, amount);
                drainedAmount += a;
                amount -= a;
                if (a > 0) {
                    int color = Aspect.getPrimalAspects().indexOf(aspect);
                    VisNetHandler.generateVisEffect(world.field_73011_w.field_76574_g, x, y, z, node.field_145851_c, node.field_145848_d, node.field_145849_e, color);
                }
                if (amount > 0) continue;
                break;
            }
        }
        return drainedAmount;
    }

    public static void generateVisEffect(int dim, int x, int y, int z, int x2, int y2, int z2, int color) {
        try {
            if (generateVisEffect == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.Utils");
                generateVisEffect = fake.getMethod("generateVisEffect", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            generateVisEffect.invoke(null, dim, x, y, z, x2, y2, z2, color);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.Utils method generateVisEffect", (Object[])new Object[0]);
        }
    }

    public static void addSource(World world, TileVisNode vs) {
        HashMap<WorldCoordinates, WeakReference<TileVisNode>> sourcelist = sources.get(world.field_73011_w.field_76574_g);
        if (sourcelist == null) {
            sourcelist = new HashMap();
        }
        sourcelist.put(vs.getLocation(), new WeakReference<TileVisNode>(vs));
        sources.put(world.field_73011_w.field_76574_g, sourcelist);
        nearbyNodes.clear();
    }

    public static boolean isNodeValid(WeakReference<TileVisNode> node) {
        return node != null && node.get() != null && !((TileVisNode)((Object)node.get())).func_145837_r();
    }

    public static WeakReference<TileVisNode> addNode(World world, TileVisNode vn) {
        WeakReference<TileVisNode> ref = new WeakReference<TileVisNode>(vn);
        HashMap<WorldCoordinates, WeakReference<TileVisNode>> sourcelist = sources.get(world.field_73011_w.field_76574_g);
        if (sourcelist == null) {
            sourcelist = new HashMap();
            return null;
        }
        ArrayList<Object[]> nearby = new ArrayList<Object[]>();
        for (WeakReference<TileVisNode> root : sourcelist.values()) {
            if (!VisNetHandler.isNodeValid(root)) continue;
            TileVisNode source = (TileVisNode)((Object)root.get());
            float r = VisNetHandler.inRange(world, vn.getLocation(), source.getLocation(), vn.getRange());
            if (r > 0.0f) {
                nearby.add(new Object[]{source, Float.valueOf(r - (float)(vn.getRange() * 2))});
            }
            nearby = VisNetHandler.findClosestNodes(vn, source, nearby);
        }
        float dist = Float.MAX_VALUE;
        TileVisNode closest = null;
        if (nearby.size() > 0) {
            for (Object[] o : nearby) {
                if (!(((Float)o[1]).floatValue() < dist)) continue;
                dist = ((Float)o[1]).floatValue();
                closest = (TileVisNode)((Object)o[0]);
            }
        }
        if (closest != null) {
            closest.getChildren().add(ref);
            nearbyNodes.clear();
            return new WeakReference<TileVisNode>(closest);
        }
        return null;
    }

    public static ArrayList<Object[]> findClosestNodes(TileVisNode target, TileVisNode root, ArrayList<Object[]> in) {
        Object closestChild = null;
        for (WeakReference<TileVisNode> child : root.getChildren()) {
            TileVisNode n = (TileVisNode)((Object)child.get());
            if (n == null || ((Object)((Object)n)).equals((Object)target) || ((Object)((Object)n)).equals((Object)root) || target.getAttunement() != -1 && n.getAttunement() != -1 && n.getAttunement() != target.getAttunement()) continue;
            float r2 = VisNetHandler.inRange(n.func_145831_w(), n.getLocation(), target.getLocation(), target.getRange());
            if (r2 > 0.0f) {
                in.add(new Object[]{n, Float.valueOf(r2)});
            }
            in = VisNetHandler.findClosestNodes(target, n, in);
        }
        return in;
    }

    private static float inRange(World world, WorldCoordinates cc1, WorldCoordinates cc2, int range) {
        float distance = cc1.getDistanceSquaredToWorldCoordinates(cc2);
        return distance > (float)(range * range) ? -1.0f : distance;
    }

    private static void calculateNearbyNodes(World world, int x, int y, int z) {
        HashMap<WorldCoordinates, WeakReference<TileVisNode>> sourcelist = sources.get(world.field_73011_w.field_76574_g);
        if (sourcelist == null) {
            sourcelist = new HashMap();
            return;
        }
        ArrayList<WeakReference<TileVisNode>> cn = new ArrayList<WeakReference<TileVisNode>>();
        WorldCoordinates drainer = new WorldCoordinates(x, y, z, world.field_73011_w.field_76574_g);
        ArrayList nearby = new ArrayList();
        for (WeakReference<TileVisNode> root : sourcelist.values()) {
            if (!VisNetHandler.isNodeValid(root)) continue;
            TileVisNode source = (TileVisNode)((Object)root.get());
            TileVisNode closest = null;
            float range = Float.MAX_VALUE;
            float r = VisNetHandler.inRange(world, drainer, source.getLocation(), source.getRange());
            if (r > 0.0f) {
                range = r;
                closest = source;
            }
            ArrayList<WeakReference<TileVisNode>> children = new ArrayList<WeakReference<TileVisNode>>();
            children = VisNetHandler.getAllChildren(source, children);
            for (WeakReference<TileVisNode> child : children) {
                float r2;
                TileVisNode n = (TileVisNode)((Object)child.get());
                if (n == null || ((Object)((Object)n)).equals(root) || !((r2 = VisNetHandler.inRange(n.func_145831_w(), n.getLocation(), drainer, n.getRange())) > 0.0f) || !(r2 < range)) continue;
                range = r2;
                closest = n;
            }
            if (closest == null) continue;
            cn.add(new WeakReference<TileVisNode>(closest));
        }
        nearbyNodes.put(drainer, cn);
    }

    private static ArrayList<WeakReference<TileVisNode>> getAllChildren(TileVisNode source, ArrayList<WeakReference<TileVisNode>> list) {
        for (WeakReference<TileVisNode> child : source.getChildren()) {
            TileVisNode n = (TileVisNode)((Object)child.get());
            if (n == null) continue;
            list.add(child);
            list = VisNetHandler.getAllChildren(n, list);
        }
        return list;
    }

    static {
        sources = new HashMap();
        nearbyNodes = new HashMap();
    }
}

