/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.NEISettings;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.NEISettingsImpl;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.ApiStatus;

public class UISettings {
    public static final double DEFAULT_INTERACT_RANGE = 8.0;
    private Supplier<ModularContainer> containerSupplier;
    private Predicate<EntityPlayer> canInteractWith;
    private final NEISettings neiSettings;

    public UISettings() {
        this(new NEISettingsImpl());
    }

    public UISettings(NEISettings neiSettings) {
        this.neiSettings = neiSettings;
    }

    public void customContainer(Supplier<ModularContainer> containerSupplier) {
        this.containerSupplier = containerSupplier;
    }

    public void canInteractWith(Predicate<EntityPlayer> canInteractWith) {
        this.canInteractWith = canInteractWith;
    }

    @ApiStatus.Internal
    public <D extends GuiData> void defaultCanInteractWith(UIFactory<D> factory, D guiData) {
        this.canInteractWith(player -> factory.canInteractWith((EntityPlayer)player, guiData));
    }

    public void canInteractWithinRange(double x, double y, double z, double range) {
        this.canInteractWith(player -> player.func_70092_e(x, y, z) <= range * range);
    }

    public void canInteractWithinRange(int x, int y, int z, double range) {
        this.canInteractWithinRange((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range);
    }

    public void canInteractWithinRange(PosGuiData guiData, double range) {
        this.canInteractWithinRange((double)guiData.getX() + 0.5, (double)guiData.getY() + 0.5, (double)guiData.getZ() + 0.5, range);
    }

    public void canInteractWithinDefaultRange(double x, double y, double z) {
        this.canInteractWithinRange(x, y, z, 8.0);
    }

    public void canInteractWithinDefaultRange(int x, int y, int z) {
        this.canInteractWithinRange(x, y, z, 8.0);
    }

    public void canInteractWithinDefaultRange(PosGuiData guiData) {
        this.canInteractWithinRange(guiData, 8.0);
    }

    public NEISettings getNEISettings() {
        return this.neiSettings;
    }

    @ApiStatus.Internal
    public ModularContainer createContainer() {
        return this.containerSupplier.get();
    }

    public boolean hasContainer() {
        return this.containerSupplier != null;
    }

    public boolean canPlayerInteractWithUI(EntityPlayer player) {
        return this.canInteractWith == null || this.canInteractWith.test(player);
    }
}

