/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.api.definitions.IBlockDefinition;
import appeng.util.Platform;
import appeng.worldgen.meteorite.IMeteoriteWorld;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class Fallout {
    private final MeteoriteBlockPutter putter;
    private final IBlockDefinition skyStoneDefinition;
    private static HashMap<Integer, Block[]> dimensionDebrisBlocks = new HashMap();
    private static HashMap<Integer, int[]> dimensionDebrisMeta = new HashMap();

    public Fallout(MeteoriteBlockPutter putter, IBlockDefinition skyStoneDefinition) {
        this.putter = putter;
        dimensionDebrisBlocks.putIfAbsent(0, new Block[]{null, null, null, null, null});
        dimensionDebrisMeta.putIfAbsent(0, new int[]{0, 0, 0, 0, 0});
        this.skyStoneDefinition = skyStoneDefinition;
    }

    public static void addDebrisToDimension(int dimensionID, Block[] list, int[] meta) {
        dimensionDebrisBlocks.put(dimensionID, list);
        dimensionDebrisMeta.put(dimensionID, meta);
    }

    public int adjustCrater() {
        return 0;
    }

    public void getRandomFall(double random, IMeteoriteWorld w, int x, int y, int z) {
        Block[] list = dimensionDebrisBlocks.get(w.getWorld().field_73011_w.field_76574_g);
        int[] meta = dimensionDebrisMeta.get(w.getWorld().field_73011_w.field_76574_g);
        if (random > 0.9) {
            this.putter.put(w, x, y, z, list[0] == null ? Blocks.field_150348_b : list[0], meta[0]);
        } else if (random > 0.8) {
            this.putter.put(w, x, y, z, list[1] == null ? Blocks.field_150347_e : list[1], meta[1]);
        } else if (random > 0.7) {
            this.putter.put(w, x, y, z, list[2] == null ? w.getWorld().func_72807_a((int)x, (int)z).field_76753_B : list[2], meta[2]);
        } else {
            this.putter.put(w, x, y, z, list[3] == null ? Blocks.field_150351_n : list[3], meta[3]);
        }
    }

    public void getRandomInset(double random, IMeteoriteWorld w, int x, int y, int z) {
        Block[] list = dimensionDebrisBlocks.get(w.getWorld().field_73011_w.field_76574_g);
        int[] meta = dimensionDebrisMeta.get(w.getWorld().field_73011_w.field_76574_g);
        if (random > 0.9) {
            this.putter.put(w, x, y, z, list[1] == null ? Blocks.field_150347_e : list[1], meta[1]);
        } else if (random > 0.8) {
            this.putter.put(w, x, y, z, list[0] == null ? Blocks.field_150348_b : list[0], meta[0]);
        } else if (random > 0.7) {
            this.putter.put(w, x, y, z, list[4] == null ? w.getWorld().func_72807_a((int)x, (int)z).field_76752_A : list[4], meta[4]);
        } else if (random > 0.6) {
            for (Block skyStoneBlock : this.skyStoneDefinition.maybeBlock().asSet()) {
                this.putter.put(w, x, y, z, skyStoneBlock);
            }
        } else if (random > 0.5) {
            this.putter.put(w, x, y, z, list[3] == null ? Blocks.field_150351_n : list[3], meta[3]);
        } else {
            this.putter.put(w, x, y, z, Platform.AIR_BLOCK);
        }
    }
}

