/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.ScrollWidget;
import com.cleanroommc.modularui.widget.SingleChildWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DropDownMenu
extends SingleChildWidget<DropDownMenu>
implements Interactable {
    private static final IKey NONE = IKey.str("None");
    private final DropDownWrapper menu = new DropDownWrapper();
    private IDrawable arrowClosed;
    private IDrawable arrowOpened;

    public DropDownMenu() {
        this.menu.setEnabled(false);
        this.menu.background(GuiTextures.BUTTON_CLEAN);
        this.child(this.menu);
        this.setArrows(GuiTextures.ARROW_UP, GuiTextures.ARROW_DOWN);
    }

    public int getSelectedIndex() {
        return this.menu.getCurrentIndex();
    }

    public DropDownMenu setSelectedIndex(int index) {
        this.menu.setCurrentIndex(index);
        return (DropDownMenu)this.getThis();
    }

    public DropDownMenu addChoice(Function<Integer, DropDownItem> itemGetter) {
        this.menu.addChoice(itemGetter);
        return (DropDownMenu)this.getThis();
    }

    public DropDownMenu setArrows(IDrawable arrowClosed, IDrawable arrowOpened) {
        this.arrowClosed = arrowClosed;
        this.arrowOpened = arrowOpened;
        return (DropDownMenu)this.getThis();
    }

    public DropDownMenu setMaxItemsToDisplay(int maxItems) {
        this.menu.setMaxItemsToDisplay(maxItems);
        return (DropDownMenu)this.getThis();
    }

    public DropDownMenu addChoice(ItemSelected onSelect, IDrawable ... drawable) {
        DropDownItem item = new DropDownItem();
        return this.addChoice(index -> (DropDownItem)((DropDownItem)item.onMouseReleased(m -> {
            this.menu.setOpened(false);
            this.menu.setCurrentIndex((int)index);
            onSelect.selected(this);
            return true;
        })).overlay(drawable));
    }

    public DropDownMenu addChoice(ItemSelected onSelect, String text) {
        return this.addChoice(onSelect, IKey.str(text));
    }

    public DropDownMenu setDropDownDirection(DropDownDirection direction) {
        this.menu.setDropDownDirection(direction);
        return (DropDownMenu)this.getThis();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (!this.menu.isOpen()) {
            this.menu.setOpened(true);
            this.menu.setEnabled(true);
            return Interactable.Result.SUCCESS;
        }
        this.menu.setOpened(false);
        this.menu.setEnabled(false);
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        super.draw(context, widgetTheme);
        Area area = this.getArea();
        int smallerSide = Math.min(area.width, area.height);
        if (this.menu.getSelectedItem() != null) {
            this.menu.getSelectedItem().setEnabled(true);
            this.menu.getSelectedItem().drawBackground(context, widgetTheme);
            this.menu.getSelectedItem().draw(context, widgetTheme);
            this.menu.getSelectedItem().drawForeground(context);
        } else {
            NONE.draw(context, 0, 0, area.width, area.height, this.getWidgetTheme(context.getTheme()));
        }
        int arrowSize = smallerSide / 2;
        if (this.menu.isOpen()) {
            this.arrowOpened.draw(context, area.width - arrowSize, arrowSize / 2, arrowSize, arrowSize, this.getWidgetTheme(context.getTheme()));
        } else {
            this.arrowClosed.draw(context, area.width - arrowSize, arrowSize / 2, arrowSize, arrowSize, this.getWidgetTheme(context.getTheme()));
        }
    }

    @Override
    public DropDownMenu background(IDrawable ... background) {
        this.menu.background(background);
        return (DropDownMenu)super.background(background);
    }

    private static class DropDownWrapper
    extends ScrollWidget<DropDownWrapper> {
        private DropDownDirection direction = DropDownDirection.DOWN;
        private int maxItemsOnDisplay = 10;
        private final List<IWidget> children = new ArrayList<IWidget>();
        private boolean open;
        private int count = 0;
        private int currentIndex = -1;

        private DropDownWrapper() {
        }

        public void setDropDownDirection(DropDownDirection direction) {
            this.direction = direction;
        }

        @Override
        public void onUpdate() {
            if (!this.open) {
                this.setEnabled(false);
            }
        }

        public void setOpened(boolean open) {
            this.open = open;
            this.rebuild();
        }

        public boolean isOpen() {
            return this.open;
        }

        public void addChoice(Function<Integer, DropDownItem> itemGetter) {
            this.children.add(itemGetter.apply(this.count));
            ++this.count;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        @Override
        @NotNull
        public List<IWidget> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public IWidget getSelectedItem() {
            if (this.currentIndex < 0 || this.currentIndex >= this.count) {
                return null;
            }
            return this.getChildren().get(this.currentIndex);
        }

        @Override
        public DropDownWrapper background(IDrawable ... background) {
            for (IWidget child : this.getChildren()) {
                if (!(child instanceof Widget)) continue;
                Widget childAsWidget = (Widget)child;
                childAsWidget.background(background);
            }
            return (DropDownWrapper)super.background(new IDrawable[0]);
        }

        public void setMaxItemsToDisplay(int maxItems) {
            this.maxItemsOnDisplay = maxItems;
        }

        @Override
        public void onResized() {
            super.onResized();
            if (!this.isValid()) {
                return;
            }
            Area parentArea = this.getParent().getArea();
            this.size(parentArea.width, parentArea.height * this.maxItemsOnDisplay);
            this.pos(0, this.direction == DropDownDirection.UP ? -parentArea.height * (this.maxItemsOnDisplay + 1) : parentArea.height);
            List<IWidget> children = this.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                IWidget child = children.get(i);
                child.getArea().setSize(parentArea.width, parentArea.height);
                child.getArea().setPos(0, parentArea.height * i);
                ((Flex)child.getFlex().left(0)).top(parentArea.height * i);
                child.setEnabled(this.open);
            }
        }

        private void rebuild() {
            WidgetTree.resize(this);
        }
    }

    public static class DropDownItem
    extends ButtonWidget<DropDownItem> {
        @Override
        public WidgetTheme getWidgetThemeInternal(ITheme theme) {
            return theme.getFallback();
        }
    }

    @FunctionalInterface
    public static interface ItemSelected {
        public void selected(DropDownMenu var1);
    }

    public static enum DropDownDirection {
        UP(0, -1),
        DOWN(0, 1);

        private final int xOffset;
        private final int yOffset;

        private DropDownDirection(int xOffset, int yOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }
    }
}

