/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.utils.ReverseIterable;
import com.cleanroommc.modularui.widget.WidgetTree;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class PanelManager {
    private final ModularScreen screen;
    private final ModularPanel mainPanel;
    private final ObjectList<ModularPanel> panels = ObjectList.create();
    private final List<ModularPanel> panelsClone = new ArrayList<ModularPanel>();
    private final List<ModularPanel> panelsView = Collections.unmodifiableList(this.panelsClone);
    private final ReverseIterable<ModularPanel> reversePanels = new ReverseIterable<ModularPanel>(this.panelsView);
    private final ObjectList<ModularPanel> disposal = ObjectList.create(20);
    private final Map<String, IPanelHandler> panelHandlerMap = new Object2ObjectOpenHashMap();
    private boolean cantDisposeNow = false;
    private boolean dirty = false;
    private State state = State.INIT;

    public PanelManager(ModularScreen screen, ModularPanel panel) {
        this.screen = screen;
        this.mainPanel = Objects.requireNonNull(panel, "Main panel must not be null!");
    }

    boolean tryInit() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("Can't init in closed state!");
        }
        if (this.state == State.INIT || this.state == State.DISPOSED) {
            this.setState(State.OPEN);
            this.openPanel(this.mainPanel, false);
            this.checkDirty();
            return true;
        }
        return false;
    }

    public boolean isMainPanel(ModularPanel panel) {
        return this.mainPanel == panel;
    }

    void checkDirty() {
        if (this.dirty) {
            this.panelsClone.clear();
            this.panelsClone.addAll((Collection<ModularPanel>)((Object)this.panels));
            this.dirty = false;
        }
    }

    private void openPanel(ModularPanel panel, boolean resize) {
        if (this.panels.size() == 127) {
            throw new IllegalStateException("Too many panels are open!");
        }
        if (this.panels.contains(panel) || this.isPanelOpen(panel.getName())) {
            throw new IllegalStateException("Panel " + panel.getName() + " is already open.");
        }
        this.disposal.remove(panel);
        panel.setPanelGuiContext(this.screen.getContext());
        this.panels.addFirst(panel);
        this.dirty = true;
        panel.getArea().setPanelLayer((byte)this.panels.size());
        panel.onOpen(this.screen);
        if (resize) {
            WidgetTree.resize(panel);
        }
    }

    public boolean isPanelOpen(String name) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            if (!panel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ModularScreen getScreen() {
        return this.screen;
    }

    @NotNull
    public ModularPanel getMainPanel() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Screen has been disposed");
        }
        return this.mainPanel;
    }

    @NotNull
    public ModularPanel getTopMostPanel() {
        return this.panels.getFirst();
    }

    @Nullable
    public IWidget getTopWidget() {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            IWidget widget = panel.getTopHovering();
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    @Nullable
    public LocatedWidget getTopWidgetLocated(boolean debug) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            LocatedWidget widget = panel.getTopHoveringLocated(debug);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    @ApiStatus.Internal
    public void openPanel(@NotNull ModularPanel panel, @NotNull IPanelHandler panelHandler) {
        IPanelHandler existing = this.panelHandlerMap.get(panel.getName());
        if (existing == null) {
            this.panelHandlerMap.put(panel.getName(), panelHandler);
        } else if (existing != panelHandler) {
            ModularUI.LOGGER.error("Tried to open a panel, but a panel handler that opens the same panel already exists. Using existing panel handler!");
            existing.openPanel();
            return;
        }
        this.openPanel(panel, true);
    }

    public void closePanel(@NotNull ModularPanel panel) {
        if (!this.hasOpenPanel(panel)) {
            throw new IllegalArgumentException("Panel '" + panel.getName() + "' is open in this screen!");
        }
        if (panel == this.getMainPanel()) {
            this.closeAll();
            this.screen.close(true);
            return;
        }
        if (this.panels.remove(panel)) {
            this.finalizePanel(panel);
            this.dirty = true;
        }
    }

    public void closeTopPanel(boolean animate) {
        this.getTopMostPanel().closeIfOpen(animate);
    }

    public boolean closeAll() {
        if (this.state.isOpen) {
            this.panels.forEach(this::finalizePanel);
            this.setState(State.CLOSED);
            return true;
        }
        return false;
    }

    private void finalizePanel(ModularPanel panel) {
        panel.onClose();
        if (!this.disposal.contains(panel)) {
            if (this.disposal.size() == 20) {
                this.disposal.removeFirst().dispose();
            }
            this.disposal.add(panel);
        }
    }

    public <T> T doSafe(Supplier<T> runnable) {
        if (this.isDisposed()) {
            return null;
        }
        this.cantDisposeNow = true;
        T t = runnable.get();
        this.cantDisposeNow = false;
        if (this.state == State.WAIT_DISPOSAL) {
            this.setState(State.CLOSED);
            this.dispose();
        }
        return t;
    }

    @ApiStatus.Internal
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.cantDisposeNow) {
            this.setState(State.WAIT_DISPOSAL);
            return;
        }
        if (!this.isClosed()) {
            throw new IllegalStateException("Must close screen first before disposing!");
        }
        this.disposal.forEach(ModularPanel::dispose);
        this.disposal.clear();
        this.panels.clear();
        this.panelsClone.clear();
        this.dirty = false;
        this.setState(State.DISPOSED);
    }

    @ApiStatus.Internal
    public void reopen() {
        if (this.panels.isEmpty()) {
            throw new IllegalStateException("Screen is disposed. Can't be recovered!");
        }
        this.panels.forEach(ModularPanel::reopen);
        this.disposal.removeIf(arg_0 -> this.panels.contains(arg_0));
        this.setState(State.REOPENED);
    }

    public boolean hasOpenPanel(ModularPanel panel) {
        return this.panels.contains(panel);
    }

    public void pushUp(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == 0) {
            return;
        }
        this.panels.remove(index);
        this.panels.add(index - 1, window);
    }

    public void pushDown(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == this.panels.size() - 1) {
            return;
        }
        this.panels.remove(index);
        this.panels.add(index + 1, window);
    }

    public void pushToTop(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == 0) {
            return;
        }
        this.panels.remove(index);
        this.panels.addFirst(window);
    }

    public void pushToBottom(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == this.panels.size() - 1) {
            return;
        }
        this.panels.remove(index);
        this.panels.addLast(window);
    }

    @NotNull
    public @UnmodifiableView List<ModularPanel> getOpenPanels() {
        this.checkDirty();
        return this.panelsView;
    }

    @NotNull
    public @UnmodifiableView Iterable<ModularPanel> getReverseOpenPanels() {
        this.checkDirty();
        return this.reversePanels;
    }

    private void setState(State state) {
        this.state = state;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED || this.state == State.DISPOSED;
    }

    public boolean isDisposed() {
        return this.state == State.DISPOSED;
    }

    public boolean isOpen() {
        return this.state.isOpen;
    }

    public boolean isReopened() {
        return this.state == State.REOPENED;
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Screen is disposed!");
        }
    }

    public static enum State {
        INIT(false),
        OPEN(true),
        REOPENED(true),
        CLOSED(false),
        WAIT_DISPOSAL(true),
        DISPOSED(false);

        public final boolean isOpen;

        private State(boolean isOpen) {
            this.isOpen = isOpen;
        }
    }
}

