/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemWeapon
extends ItemBase {
    public ItemWeapon(int weight, int level) {
        super(weight, level);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        return ItemWeapon.getRandom(rand, level, true);
    }

    public static ItemStack getRandom(Random rand, int rank, boolean enchant) {
        if (rand.nextInt(10) == 0) {
            return ItemWeapon.getBow(rand, rank, enchant);
        }
        return ItemWeapon.getSword(rand, rank, enchant);
    }

    public static ItemStack getBow(Random rand, int level, boolean enchant) {
        if (rand.nextInt(20 + level * 10) == 0) {
            return ItemSpecialty.getRandomItem(Equipment.BOW, rand, level);
        }
        ItemStack bow = new ItemStack((Item)Items.field_151031_f);
        if (enchant && rand.nextInt(6 - level) == 0) {
            Enchant.enchantItem(rand, bow, Enchant.getLevel(rand, level));
        }
        return bow;
    }

    public static ItemStack getSword(Random rand, int level, boolean enchant) {
        if (enchant && rand.nextInt(10 + level * 10) == 0) {
            return ItemSpecialty.getRandomItem(Equipment.SWORD, rand, level);
        }
        ItemStack sword = ItemWeapon.pickSword(rand, level);
        if (enchant && rand.nextInt(6 - level) == 0) {
            Enchant.enchantItem(rand, sword, Enchant.getLevel(rand, level));
        }
        return sword;
    }

    private static ItemStack pickSword(Random rand, int level) {
        Quality quality = Quality.getWeaponQuality(rand, level);
        switch (quality) {
            case DIAMOND: {
                return new ItemStack(Items.field_151048_u);
            }
            case GOLD: {
                return new ItemStack(Items.field_151010_B);
            }
            case IRON: {
                return new ItemStack(Items.field_151040_l);
            }
            case STONE: {
                return new ItemStack(Items.field_151052_q);
            }
        }
        return new ItemStack(Items.field_151041_m);
    }
}

