/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.client.gui.widget.GuiText;
import gcewing.architecture.common.shape.Shape;

public class ShapePage {
    public final String title;
    public final Shape[] shapes;
    public final String[] shapeNames;

    public ShapePage(String title, Shape ... shapes) {
        this.title = title;
        this.shapes = shapes;
        this.shapeNames = new String[shapes.length];
    }

    public int size() {
        return this.shapes.length;
    }

    public Shape get(int i) {
        if (i >= 0 && i < this.shapes.length) {
            return this.shapes[i];
        }
        return null;
    }

    public String getTitle() {
        try {
            return GuiText.valueOf(GuiText.class, this.title).getLocal();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "UNKNOWN";
        }
    }

    public void updateShapeNames() {
        for (int i = 0; i < this.shapes.length; ++i) {
            try {
                this.shapeNames[i] = GuiText.valueOf(GuiText.class, this.shapes[i].name()).getLocal();
                continue;
            }
            catch (IllegalArgumentException e) {
                this.shapeNames[i] = "UNKNOWN";
            }
        }
    }

    public String[] getShapeNames() {
        return this.shapeNames;
    }
}

