/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib;

import cpw.mods.fml.common.FMLLog;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.IAmplifiedRedstoneOutput;
import tuhljin.automagy.lib.IOrientableRedstoneConductor;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.BlockWithPos;

public class RedstoneCalc {
    public static final int MAX_POWER = 15;
    public static final int MAX_POWER_AMPLIFIED = 99;
    public static final boolean COUNT_PISTONHEAD_AS_AIR = true;

    public static PowerResult getRedstonePowerAt(World world, int x, int y, int z) {
        return RedstoneCalc.getRedstonePowerAt(world, x, y, z, 1, false, -1, false, 15, ForgeDirection.VALID_DIRECTIONS);
    }

    public static PowerResult getRedstonePowerAt(World world, int x, int y, int z, ForgeDirection ... directions) {
        return RedstoneCalc.getRedstonePowerAt(world, x, y, z, 1, false, -1, false, 15, directions);
    }

    public static PowerResult getRedstonePowerAt(World world, int x, int y, int z, int attachedToSide, boolean isWire, int excludeRedstoneWireDir, boolean allowAmplifiedPower) {
        return RedstoneCalc.getRedstonePowerAt(world, x, y, z, attachedToSide, isWire, excludeRedstoneWireDir, allowAmplifiedPower, 15, ForgeDirection.VALID_DIRECTIONS);
    }

    public static PowerResult getRedstonePowerAt(World world, int x, int y, int z, int attachedToSide, boolean isWire, int excludeRedstoneWireDir, boolean allowAmplifiedPower, ForgeDirection ... directions) {
        return RedstoneCalc.getRedstonePowerAt(world, x, y, z, attachedToSide, isWire, excludeRedstoneWireDir, allowAmplifiedPower, 15, directions);
    }

    public static PowerResult getRedstonePowerAt(World world, int x, int y, int z, int attachedToSide, boolean isWire, int excludeRedstoneWireDir, boolean allowAmplifiedPower, int maxPower, ForgeDirection ... directions) {
        int strength = 0;
        ForgeDirection directionToPower = ForgeDirection.UNKNOWN;
        for (ForgeDirection dir : directions) {
            int x2 = x + dir.offsetX;
            int y2 = y + dir.offsetY;
            int z2 = z + dir.offsetZ;
            Block block = world.func_147439_a(x2, y2, z2);
            if (block instanceof BlockRedstoneWire) {
                if (excludeRedstoneWireDir != dir.ordinal()) {
                    int metadata = world.func_72805_g(x2, y2, z2);
                    if (isWire) {
                        --metadata;
                    }
                    if (metadata > strength) {
                        strength = metadata;
                        directionToPower = dir;
                    }
                }
            } else if (block instanceof IAmplifiedRedstoneOutput) {
                IAmplifiedRedstoneOutput amp = (IAmplifiedRedstoneOutput)block;
                int data = amp.getRedstoneSignalStrength((IBlockAccess)world, x2, y2, z2, dir.getOpposite().ordinal(), allowAmplifiedPower);
                if (isWire && amp.isRedstoneWire()) {
                    --data;
                }
                if (data > strength) {
                    strength = data;
                    directionToPower = dir;
                }
            } else if (RedstoneCalc.isAirBlock(block, (IBlockAccess)world, x2, y2, z2)) {
                BlockWithPos bwp;
                if (isWire && (bwp = RedstoneCalc.getORCAroundCorner((IBlockAccess)world, x2, y2, z2, attachedToSide, dir)) != null) {
                    int data = ((IOrientableRedstoneConductor)bwp.block).getRedstoneSignalStrength((IBlockAccess)world, bwp.x, bwp.y, bwp.z, attachedToSide, allowAmplifiedPower);
                    if (--data > strength) {
                        strength = data;
                        directionToPower = dir;
                    }
                }
            } else {
                int s = world.func_72878_l(x2, y2, z2, dir.ordinal());
                if (s > strength) {
                    if (isWire && !block.func_149744_f()) {
                        for (ForgeDirection subdir : ForgeDirection.VALID_DIRECTIONS) {
                            int s2;
                            int z3;
                            int y3;
                            int x3;
                            Block block2;
                            if (subdir.getOpposite() == dir || (block2 = world.func_147439_a(x3 = x2 + subdir.offsetX, y3 = y2 + subdir.offsetY, z3 = z2 + subdir.offsetZ)) instanceof BlockRedstoneWire || block2 instanceof IOrientableRedstoneConductor || !block2.func_149744_f() || (s2 = block2.func_149748_c((IBlockAccess)world, x3, y3, z3, subdir.ordinal())) != s) continue;
                            strength = s;
                            directionToPower = dir;
                            break;
                        }
                    } else {
                        strength = s;
                        directionToPower = dir;
                    }
                }
            }
            if (strength >= (allowAmplifiedPower ? 99 : maxPower)) break;
        }
        return strength > 0 ? new PowerResult(strength, directionToPower) : null;
    }

    public static boolean isAirBlock(Block block, IBlockAccess blockaccess, int x, int y, int z) {
        return blockaccess.func_147437_c(x, y, z) || block == Blocks.field_150332_K;
    }

    public static BlockWithPos getORCAroundCorner(IBlockAccess blockaccess, int x2, int y2, int z2, int attachedToSide, ForgeDirection dir) {
        int z3;
        int y3;
        int x3;
        Block block2;
        ForgeDirection side = ForgeDirection.getOrientation((int)attachedToSide);
        if (side == ForgeDirection.UNKNOWN) {
            FMLLog.log((Level)Level.ERROR, (String)"[Automagy] RedstoneCalc was passed UNKNOWN attachedToSide. Will calculate as if given DOWN.", (Object[])new Object[0]);
            side = ForgeDirection.DOWN;
        }
        ForgeDirection subdir = side.getOpposite();
        if (dir.ordinal() != attachedToSide && subdir.ordinal() != attachedToSide && (block2 = blockaccess.func_147439_a(x3 = x2 + subdir.offsetX, y3 = y2 + subdir.offsetY, z3 = z2 + subdir.offsetZ)) instanceof IOrientableRedstoneConductor) {
            int otherside = ((IOrientableRedstoneConductor)block2).getOrientation(blockaccess, x3, y3, z3);
            if (TjUtil.getNextSideOnBlockFromDir(attachedToSide, dir.ordinal()) == otherside) {
                return new BlockWithPos(block2, blockaccess, x3, y3, z3);
            }
        }
        return null;
    }

    public static LinkedHashMap<BlockCoord, ForgeDirection> getConnectedWireAwayFromSource(IBlockAccess blockaccess, int x, int y, int z) {
        LinkedHashMap<BlockCoord, ForgeDirection> wiring = new LinkedHashMap<BlockCoord, ForgeDirection>();
        RedstoneCalc.buildWiringSet(wiring, blockaccess, x, y, z, -1, 2);
        wiring.remove(new BlockCoord(x, y, z));
        return wiring;
    }

    public static LinkedHashMap<BlockCoord, ForgeDirection> getConnectedWireAwayFromSourceWithNoInputPoint(IBlockAccess blockaccess, int x, int y, int z) {
        LinkedHashMap<BlockCoord, ForgeDirection> wiring = new LinkedHashMap<BlockCoord, ForgeDirection>();
        boolean ret = RedstoneCalc.buildWiringSet(wiring, blockaccess, x, y, z, -1, -1);
        if (ret) {
            return null;
        }
        wiring.remove(new BlockCoord(x, y, z));
        return wiring;
    }

    private static boolean buildWiringSet(LinkedHashMap<BlockCoord, ForgeDirection> wiring, IBlockAccess blockaccess, int x, int y, int z, int backDir, int distance) {
        BlockCoord bc = new BlockCoord(x, y, z);
        if (!wiring.containsKey(bc)) {
            Block block = blockaccess.func_147439_a(x, y, z);
            if (backDir == -1 || block instanceof IOrientableRedstoneConductor) {
                IOrientableRedstoneConductor orc;
                IOrientableRedstoneConductor iOrientableRedstoneConductor = orc = block instanceof IOrientableRedstoneConductor ? (IOrientableRedstoneConductor)block : null;
                if (backDir != -1 && !orc.canReceiveRedstoneSignalFromDirection(blockaccess, x, y, z, backDir) && !orc.canSendRedstoneSignalInDirection(blockaccess, x, y, z, backDir)) {
                    return false;
                }
                wiring.put(bc, ForgeDirection.getOrientation((int)backDir));
                if (distance == -1) {
                    if (orc != null && orc.isRedstoneSignalInputPoint(blockaccess, x, y, z)) {
                        return true;
                    }
                } else if (--distance == 0) {
                    return false;
                }
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir.ordinal() == backDir || orc != null && !orc.canSendRedstoneSignalInDirection(blockaccess, x, y, z, dir.ordinal()) && !orc.canReceiveRedstoneSignalFromDirection(blockaccess, x, y, z, dir.ordinal())) continue;
                    int x2 = x + dir.offsetX;
                    int y2 = y + dir.offsetY;
                    int z2 = z + dir.offsetZ;
                    if (RedstoneCalc.isAirBlock(block, blockaccess, x2, y2, z2)) {
                        boolean ret;
                        BlockWithPos bwp;
                        int attachedToSide;
                        if (orc == null) {
                            for (attachedToSide = 0; attachedToSide < 6; ++attachedToSide) {
                                bwp = RedstoneCalc.getORCAroundCorner(blockaccess, x2, y2, z2, attachedToSide, dir);
                                if (bwp == null || !(ret = RedstoneCalc.buildWiringSet(wiring, blockaccess, bwp.x, bwp.y, bwp.z, attachedToSide, distance))) continue;
                                return true;
                            }
                            continue;
                        }
                        attachedToSide = orc.getOrientation(blockaccess, x, y, z);
                        bwp = RedstoneCalc.getORCAroundCorner(blockaccess, x2, y2, z2, attachedToSide, dir);
                        if (bwp == null || !(ret = RedstoneCalc.buildWiringSet(wiring, blockaccess, bwp.x, bwp.y, bwp.z, attachedToSide, distance))) continue;
                        return true;
                    }
                    boolean ret = RedstoneCalc.buildWiringSet(wiring, blockaccess, x2, y2, z2, dir.getOpposite().ordinal(), distance);
                    if (!ret) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getRedstoneSignalStrengthFromValues(int amt, int capacity) {
        if (amt < 1 || capacity < 1) {
            return 0;
        }
        if (amt >= capacity) {
            return 15;
        }
        int strength = MathHelper.func_76141_d((float)(1.0f + (float)amt / (float)capacity * 14.0f));
        return strength;
    }

    public static class PowerResult {
        public final int strength;
        public final ForgeDirection sourceDirection;

        public PowerResult(int strength, ForgeDirection sourceDirection) {
            this.strength = strength;
            this.sourceDirection = sourceDirection;
        }
    }
}

