/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.CustomDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.DiagramFactory;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.DiagramUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFluidDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFormatting;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import gregtech.api.enums.Materials;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.objects.ItemData;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public final class GregTechMaterialTools
implements DiagramGenerator {
    public static final ItemComponent ICON = ItemComponent.createWithNbt(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, Materials.Aluminium, Materials.Wood, null));
    private final DiagramGroupInfo info;
    private final LayoutHandler layoutHandler;
    private final RecipeHandler recipeHandler;
    private final DiagramFactory diagramFactory;
    private ImmutableBiMap<Materials, Diagram> materialsMap;

    public GregTechMaterialTools(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.GREGTECH_5_MATERIAL_TOOLS.trans("groupname"), groupId, ICON, 1).setIgnoreNbt(false).setEmptyDiagramPredicate(DiagramUtil.buildEmptyDiagramPredicate(2)).setDescription("This diagram displays craftable GregTech tools for each GregTech material.").build();
        this.layoutHandler = new LayoutHandler(this.info);
        this.recipeHandler = new RecipeHandler();
        this.diagramFactory = new DiagramFactory(this.layoutHandler, this.recipeHandler);
        this.materialsMap = null;
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public DiagramGroup generate() {
        this.layoutHandler.initialize();
        this.recipeHandler.initialize();
        ImmutableBiMap.Builder materialsMapBuilder = ImmutableBiMap.builder();
        for (Materials material : Materials.getAll()) {
            materialsMapBuilder.put((Object)material, (Object)this.diagramFactory.buildDiagram(material));
        }
        this.materialsMap = materialsMapBuilder.build();
        return new DiagramGroup(this.info, new CustomDiagramMatcher((Iterable<? extends Diagram>)this.materialsMap.values(), this::getDiagram));
    }

    private List<Diagram> getDiagram(Interactable.RecipeType unused, Component component) {
        component = GregTechFluidDictUtil.fillCell(component).map(Component.class::cast).orElse(component);
        Materials material = null;
        if (component.type() == Component.ComponentType.ITEM && ((ItemComponent)component).item() instanceof MetaGeneratedTool) {
            material = MetaGeneratedTool.getPrimaryMaterial((ItemStack)((ItemStack)component.stack()));
        } else {
            Optional<ItemData> itemDataOptional = GregTechOreDictUtil.getItemData(component);
            if (itemDataOptional.isPresent() && itemDataOptional.get().mMaterial != null) {
                material = itemDataOptional.get().mMaterial.mMaterial;
            }
        }
        if (material != null) {
            if (this.materialsMap.containsKey((Object)material)) {
                return Lists.newArrayList((Object[])new Diagram[]{(Diagram)this.materialsMap.get((Object)material)});
            }
            Logger.GREGTECH_5_MATERIAL_TOOLS.error("Did not generate diagram for material: {}", new Object[]{GregTechFormatting.getMaterialDescription(material)});
        }
        return Lists.newArrayList();
    }
}

