/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.tileentities.storage.MTEQuantumChest;
import logisticspipes.proxy.specialinventoryhandler.DSULikeInventoryHandler;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class QuantumChestInventoryHandler
extends DSULikeInventoryHandler {
    private final MTEQuantumChest _mte;

    private QuantumChestInventoryHandler(MTEQuantumChest tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._mte = tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public QuantumChestInventoryHandler() {
        this._mte = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        if (!(tile instanceof IGregTechTileEntity)) {
            return false;
        }
        return ((IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEQuantumChest;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new QuantumChestInventoryHandler((MTEQuantumChest)((IGregTechTileEntity)tile).getMetaTileEntity(), hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    boolean isEmpty() {
        return this._mte.mItemCount == 0 || this._mte.mItemStack == null;
    }

    @Override
    int getSize() {
        return this._mte.getMaxItemCount();
    }

    @Override
    int getCurrent() {
        return this._mte.mItemCount;
    }

    @Override
    ItemStack getType() {
        return this._mte.mItemStack;
    }

    @Override
    void setContent(int count) {
        this._mte.mItemCount = count;
    }

    @Override
    void setContent(ItemStack stack, int size) {
        this._mte.mItemStack = stack.func_77946_l();
        this._mte.mItemCount = size;
    }

    @Override
    void markDirty() {
        this._mte.func_70296_d();
    }
}

