/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.BarnardsSystem.planets.barnardaC.world.feature;

import galaxyspace.BarnardsSystem.BRBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenBarnardaCTree
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final int randomTreeHeight;
    private final boolean vinesGrow;
    private final Block wood;
    private final Block leaves;
    private final int metaWood;
    private int metaLeaves;
    private final int type;
    private boolean isFruitTree = false;

    public WorldGenBarnardaCTree(int type, Block wood, Block leaves, int metaWood, int metaLeaves) {
        this(type, wood, leaves, metaWood, metaLeaves, false, 4, 3, false);
    }

    public WorldGenBarnardaCTree(int type, Block wood, Block leaves, int metaWood, boolean isFruitTree) {
        this(type, wood, leaves, metaWood, -1, false, 5, 4, false);
        this.isFruitTree = isFruitTree;
    }

    public WorldGenBarnardaCTree(int type, Block wood, Block leaves, int metaWood, int metaLeaves, boolean doBlockNotify, int minTreeHeight, int randomTreeHeight, boolean vinesGrow) {
        super(doBlockNotify);
        this.wood = wood;
        this.leaves = leaves;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
        this.minTreeHeight = minTreeHeight;
        this.randomTreeHeight = randomTreeHeight;
        this.vinesGrow = vinesGrow;
        this.type = type;
    }

    public boolean func_76484_a(World par1World, Random par2Random, int par3, int par4, int par5) {
        int k1;
        int l = par2Random.nextInt(this.randomTreeHeight) + this.minTreeHeight;
        boolean flag = true;
        if (this.isFruitTree) {
            this.metaLeaves = par2Random.nextInt(4);
        }
        if (par4 < 1 || par4 + l + 1 > 256) {
            return false;
        }
        for (int i1 = par4; i1 <= par4 + 1 + l; ++i1) {
            int b0 = 1;
            if (i1 == par4) {
                b0 = 0;
            }
            if (i1 >= par4 + 1 + l - 2) {
                b0 = 2;
            }
            for (int j1 = par3 - b0; j1 <= par3 + b0 && flag; ++j1) {
                for (k1 = par5 - b0; k1 <= par5 + b0 && flag; ++k1) {
                    if (i1 >= 0 && i1 < 256) {
                        if (this.isReplaceable(par1World, j1, i1, k1)) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        Block block2 = par1World.func_147439_a(par3, par4 - 1, par5);
        boolean isSoil = block2.canSustainPlant((IBlockAccess)par1World, par3, par4 - 1, par5, ForgeDirection.UP, (IPlantable)BRBlocks.BarnardaCSapling);
        if (isSoil && par4 < 256 - l - 1) {
            int j2;
            int i3;
            int l2;
            block2.onPlantGrow(par1World, par3, par4 - 1, par5, par3, par4, par5);
            int b0 = 3;
            for (k1 = par4 - 3 + l; k1 <= par4 + l; ++k1) {
                int i2 = k1 - (par4 + l);
                l2 = 1 - i2 / 2;
                for (i3 = par3 - l2; i3 <= par3 + l2; ++i3) {
                    j2 = i3 - par3;
                    for (int k2 = par5 - l2; k2 <= par5 + l2; ++k2) {
                        int l3 = k2 - par5;
                        if (Math.abs(j2) == l2 && Math.abs(l3) == l2 && par2Random.nextInt(2) != 0 && i2 == 0) continue;
                    }
                }
            }
            for (k1 = 0; k1 < l; ++k1) {
                Block block = par1World.func_147439_a(par3, par4 + k1, par5);
                if (!block.isAir((IBlockAccess)par1World, par3, par4 + k1, par5) && !block.isLeaves((IBlockAccess)par1World, par3, par4 + k1, par5)) continue;
                if (par1World.func_147439_a(par3, par4 - 1, par5) == BRBlocks.BarnardaCGrass || par1World.func_147439_a(par3, par4 - 1, par5) == BRBlocks.BarnardaCDirt) {
                    this.variants(par1World, par3, par4, par5);
                }
                if (!this.vinesGrow || k1 <= 0) continue;
                if (par2Random.nextInt(3) > 0 && par1World.func_147437_c(par3 - 1, par4 + k1, par5)) {
                    this.func_150516_a(par1World, par3 - 1, par4 + k1, par5, Blocks.field_150395_bd, 8);
                }
                if (par2Random.nextInt(3) > 0 && par1World.func_147437_c(par3 + 1, par4 + k1, par5)) {
                    this.func_150516_a(par1World, par3 + 1, par4 + k1, par5, Blocks.field_150395_bd, 2);
                }
                if (par2Random.nextInt(3) > 0 && par1World.func_147437_c(par3, par4 + k1, par5 - 1)) {
                    this.func_150516_a(par1World, par3, par4 + k1, par5 - 1, Blocks.field_150395_bd, 1);
                }
                if (par2Random.nextInt(3) <= 0 || !par1World.func_147437_c(par3, par4 + k1, par5 + 1)) continue;
                this.func_150516_a(par1World, par3, par4 + k1, par5 + 1, Blocks.field_150395_bd, 4);
            }
            if (this.vinesGrow) {
                for (k1 = par4 - 3 + l; k1 <= par4 + l; ++k1) {
                    int i2 = k1 - (par4 + l);
                    l2 = 2 - i2 / 2;
                    for (i3 = par3 - l2; i3 <= par3 + l2; ++i3) {
                        for (j2 = par5 - l2; j2 <= par5 + l2; ++j2) {
                            if (!par1World.func_147439_a(i3, k1, j2).isLeaves((IBlockAccess)par1World, i3, k1, j2)) continue;
                            if (par2Random.nextInt(4) == 0 && par1World.func_147439_a(i3 - 1, k1, j2).isAir((IBlockAccess)par1World, i3 - 1, k1, j2)) {
                                this.growVines(par1World, i3 - 1, k1, j2, 8);
                            }
                            if (par2Random.nextInt(4) == 0 && par1World.func_147439_a(i3 + 1, k1, j2).isAir((IBlockAccess)par1World, i3 + 1, k1, j2)) {
                                this.growVines(par1World, i3 + 1, k1, j2, 2);
                            }
                            if (par2Random.nextInt(4) == 0 && par1World.func_147439_a(i3, k1, j2 - 1).isAir((IBlockAccess)par1World, i3, k1, j2 - 1)) {
                                this.growVines(par1World, i3, k1, j2 - 1, 1);
                            }
                            if (par2Random.nextInt(4) != 0 || !par1World.func_147439_a(i3, k1, j2 + 1).isAir((IBlockAccess)par1World, i3, k1, j2 + 1)) continue;
                            this.growVines(par1World, i3, k1, j2 + 1, 4);
                        }
                    }
                }
                if (par2Random.nextInt(5) == 0 && l > 5) {
                    for (k1 = 0; k1 < 2; ++k1) {
                        for (int i2 = 0; i2 < 4; ++i2) {
                            if (par2Random.nextInt(4 - k1) != 0) continue;
                            l2 = par2Random.nextInt(3);
                            this.func_150516_a(par1World, par3 + Direction.field_71583_a[Direction.field_71580_e[i2]], par4 + l - 5 + k1, par5 + Direction.field_71581_b[Direction.field_71580_e[i2]], Blocks.field_150375_by, l2 << 2 | i2);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void growVines(World world, int x, int y, int z, int flag) {
        this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
        for (int i1 = 4; !world.func_147439_a(x, --y, z).isAir((IBlockAccess)world, x, y, z) && i1 > 0; --i1) {
            this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
        }
    }

    private void variants(World par1World, int i, int j, int k) {
        if (this.type == 1) {
            this.func_150516_a(par1World, (i -= 4) + 0, j + 3, (k -= 3) + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 0, j + 4, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 0, j + 4, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 0, j + 4, k + 5, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 0, j + 5, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 3, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 3, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 4, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 5, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 5, k + 5, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 6, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 3, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 3, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 4, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 4, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 5, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 4, j + 3, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 4, j + 3, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 4, j + 4, k + 0, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 4, j + 4, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 4, j + 4, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 2, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 3, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 3, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 4, k + 0, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 4, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 5, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 5, j + 5, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 6, j + 3, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 6, j + 4, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 6, j + 4, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 4, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 1, j + 5, k + 4, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 2, j + 3, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 3, j + 2, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 3, j + 3, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 4, j + 0, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 4, j + 1, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 4, j + 2, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 5, j + 3, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 5, j + 4, k + 1, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 5, j + 4, k + 2, this.wood, this.metaWood);
        }
        if (this.type == 2) {
            this.func_150516_a(par1World, (i -= 2) + 0, j + 6, (k -= 2) + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 1, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 2, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 6, k + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 6, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 7, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 7, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 3, k + 0, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 3, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 4, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 2, j + 6, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 3, j + 2, k + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 3, j + 3, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 3, j + 4, k + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 4, j + 4, k + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(par1World, i + 1, j + 1, k + 2, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 1, j + 2, k + 1, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 1, j + 6, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 2, j + 0, k + 2, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 2, j + 2, k + 1, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 2, j + 5, k + 3, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 3, j + 3, k + 1, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 3, j + 3, k + 2, this.wood, this.metaWood);
            this.func_150516_a(par1World, i + 3, j + 4, k + 3, this.wood, this.metaWood);
        }
    }
}

