/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.nodebuffer;

import cofh.api.energy.EnergyStorage;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeEnergy;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyBuffer
implements INodeBuffer {
    TileEntityTransferNodeEnergy node;

    @Override
    public boolean transfer(TileEntity tile, ForgeDirection side, IPipe insertingPipe, int x, int y, int z, ForgeDirection travelDir) {
        return false;
    }

    @Override
    public EnergyStorage getBuffer() {
        return this.node.powerHandler;
    }

    @Override
    public String getBufferType() {
        return "energy";
    }

    @Override
    public void setBuffer(Object buffer) {
        this.node.powerHandler = (EnergyStorage)buffer;
    }

    @Override
    public boolean isEmpty() {
        return this.node.powerHandler.getEnergyStored() == 0;
    }

    @Override
    public boolean shouldSearch() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tags) {
    }

    @Override
    public void setNode(INode node) {
        this.node = (TileEntityTransferNodeEnergy)node;
    }

    @Override
    public INode getNode() {
        return this.node;
    }

    @Override
    public boolean transferTo(INodeBuffer receptor, int no) {
        if (this.isEmpty() || !this.getBufferType().equals(receptor.getBufferType())) {
            return false;
        }
        EnergyStorage t = (EnergyStorage)receptor.getBuffer();
        int e = t.receiveEnergy(this.getBuffer().extractEnergy(no * 240, true), true);
        if (e <= 0) {
            return false;
        }
        t.receiveEnergy(this.getBuffer().extractEnergy(e, false), false);
        return true;
    }

    @Override
    public synchronized Object recieve(Object a) {
        if (!(a instanceof Integer)) {
            return a;
        }
        int c = (Integer)a;
        int b = this.node.powerHandler.receiveEnergy(c, false);
        return c - b;
    }

    @Override
    public void markDirty() {
        this.node.bufferChanged();
    }
}

