/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntity;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.compat.Compat;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.IContainerSelection;
import vswe.stevesfactory.components.Variable;
import vswe.stevesfactory.interfaces.GuiManager;

public class ConnectionBlock
implements IContainerSelection {
    private TileEntity tileEntity;
    private EnumSet<ConnectionBlockType> types;
    private int id;
    private int cableDistance;

    public ConnectionBlock(TileEntity tileEntity, int cableDistance) {
        this.tileEntity = tileEntity;
        this.types = EnumSet.noneOf(ConnectionBlockType.class);
        this.cableDistance = cableDistance;
    }

    public void addType(ConnectionBlockType type) {
        this.types.add(type);
    }

    public static boolean isOfType(EnumSet<ConnectionBlockType> types, ConnectionBlockType type) {
        return type == null || types.contains((Object)type) || type == ConnectionBlockType.NODE && (types.contains((Object)ConnectionBlockType.RECEIVER) || types.contains((Object)ConnectionBlockType.EMITTER));
    }

    public boolean isOfType(ConnectionBlockType type) {
        return ConnectionBlock.isOfType(this.types, type);
    }

    public boolean isOfAnyType(EnumSet<ConnectionBlockType> types) {
        for (ConnectionBlockType type : types) {
            if (!this.isOfType(type)) continue;
            return true;
        }
        return false;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void draw(GuiManager gui, int x, int y) {
        gui.drawBlock(this.tileEntity, x, y);
    }

    @Override
    public String getDescription(GuiManager gui) {
        String str = gui.getBlockName(this.tileEntity);
        if (Compat.HAS_ADDONS) {
            str = Compat.ADDONS_HOOKS.fixToolTip(str, this.tileEntity);
        }
        str = str + this.getVariableTag(gui);
        str = str + "\n" + (Object)((Object)Localization.X) + ": " + this.tileEntity.field_145851_c + " " + (Object)((Object)Localization.Y) + ": " + this.tileEntity.field_145848_d + " " + (Object)((Object)Localization.Z) + ": " + this.tileEntity.field_145849_e;
        int distance = this.getDistance(gui.getManager());
        str = str + "\n" + distance + " " + (Object)((Object)(distance > 1 ? Localization.BLOCKS_AWAY : Localization.BLOCK_AWAY));
        str = str + "\n" + this.cableDistance + " " + (Object)((Object)(this.cableDistance > 1 ? Localization.CABLES_AWAY : Localization.CABLE_AWAY));
        return str;
    }

    public int getDistance(TileEntityManager manager) {
        return (int)Math.round(Math.sqrt(manager.func_145835_a((double)this.tileEntity.field_145851_c + 0.5, (double)this.tileEntity.field_145848_d + 0.5, (double)this.tileEntity.field_145849_e + 0.5)));
    }

    public int getCableDistance() {
        return this.cableDistance;
    }

    @Override
    public String getName(GuiManager gui) {
        return gui.getBlockName(this.tileEntity);
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private String getVariableTag(GuiManager gui) {
        int count = 0;
        String result = "";
        if (GuiScreen.func_146272_n()) {
            for (Variable variable : gui.getManager().getVariables()) {
                if (!this.isPartOfVariable(variable)) continue;
                result = result + "\n" + variable.getDescription(gui);
                ++count;
            }
        }
        return count == 0 ? "" : result;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPartOfVariable(Variable variable) {
        return variable.isValid() && ((ComponentMenuContainer)variable.getDeclaration().getMenus().get(2)).getSelectedInventories().contains(this.id);
    }
}

