/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.PageControlWidget;
import com.gtnewhorizons.modularui.common.widget.TabButton;
import java.util.ArrayList;
import java.util.List;

public class TabContainer
extends PageControlWidget {
    private final List<TabButton> tabButtons = new ArrayList<TabButton>();
    private final List<Widget> allChildren = new ArrayList<Widget>();
    private Size buttonSize = null;

    @Override
    public void initChildren() {
        this.allChildren.clear();
        this.allChildren.addAll(this.getPages());
        this.allChildren.addAll(this.tabButtons);
    }

    @Override
    public void onInit() {
        super.onInit();
        for (TabButton tabButton : this.tabButtons) {
            tabButton.setTabController(this);
            if (tabButton.getPage() < 0 || tabButton.getPage() >= this.getPages().size()) {
                throw new IndexOutOfBoundsException(String.format("TabButton page is %s, but must be 0 - %s", tabButton.getPage(), this.getPages().size() - 1));
            }
            if (this.buttonSize == null || !tabButton.isAutoSized()) continue;
            tabButton.setSize(this.buttonSize);
        }
    }

    @Override
    public List<Widget> getChildren() {
        return this.allChildren;
    }

    public TabContainer addTabButton(Widget tabButton) {
        if (!(tabButton instanceof TabButton)) {
            throw new IllegalArgumentException("Tab button must be instance of TabButton");
        }
        this.tabButtons.add((TabButton)tabButton);
        return this;
    }

    public TabContainer setButtonSize(Size buttonSize) {
        this.buttonSize = buttonSize;
        return this;
    }

    public TabContainer setButtonSize(int width, int height) {
        return this.setButtonSize(new Size(width, height));
    }
}

