/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.colour;

import cofh.repack.codechicken.lib.colour.ColourRGBA;
import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.render.TextureUtils;
import java.awt.image.BufferedImage;
import net.minecraft.util.ResourceLocation;

public class CustomGradient {
    public int[] gradient;

    public CustomGradient(ResourceLocation resourceLocation) {
        BufferedImage bufferedImage = TextureUtils.loadBufferedImage(resourceLocation);
        if (bufferedImage == null) {
            throw new RuntimeException("File not found: " + resourceLocation.toString());
        }
        int[] nArray = new int[bufferedImage.getWidth()];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), 1, nArray, 0, bufferedImage.getWidth());
        this.gradient = new int[bufferedImage.getWidth()];
        for (int i = 0; i < nArray.length; ++i) {
            this.gradient[i] = nArray[i] << 8 | nArray[i] >> 24 & 0xFF;
        }
    }

    public ColourRGBA getColour(double d) {
        return new ColourRGBA(this.getColourI(d));
    }

    public int getColourI(double d) {
        int n = (int)MathHelper.clip((double)this.gradient.length * d, 0.0, this.gradient.length - 1);
        return this.gradient[n];
    }
}

