/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.gui;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.common.internal.Theme;
import java.util.Collections;

public class AutoScalingStackSizeText
implements IDrawable {
    private static final TextRenderer measuringRenderer = new TextRenderer();
    private static final NumberFormatMUI muiNumberFormat = new NumberFormatMUI();
    private static final TextRenderer renderer = new TextRenderer();
    private Alignment alignment = Alignment.Center;
    private final String text;
    private int simWidth;
    private int color;
    private boolean shadow = false;

    public AutoScalingStackSizeText(long stackSize) {
        this.text = muiNumberFormat.formatWithSuffix(stackSize);
        this.color = Theme.INSTANCE.getText();
        this.measure();
    }

    public AutoScalingStackSizeText color(int color) {
        this.color = Color.withAlpha((int)color, (int)255);
        return this;
    }

    public AutoScalingStackSizeText shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public AutoScalingStackSizeText shadow() {
        return this.shadow(true);
    }

    public AutoScalingStackSizeText alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public AutoScalingStackSizeText measure() {
        this.simWidth = measuringRenderer.getMaxWidth(Collections.singletonList(this.text));
        return this;
    }

    public boolean hasColor() {
        return Color.getAlpha((int)this.color) > 0;
    }

    public void applyThemeColor(int color) {
        renderer.setColor(this.hasColor() ? this.color : Theme.INSTANCE.getText());
    }

    public void draw(float x, float y, float width, float height, float partialTicks) {
        renderer.setPos((int)((double)x - 0.5), (int)((double)y - 0.5));
        renderer.setShadow(this.shadow);
        renderer.setAlignment(this.alignment, width, height);
        renderer.setColor(this.color);
        renderer.setScale((float)this.simWidth <= 16.0f ? 1.0f : 16.0f / (float)this.simWidth);
        renderer.draw(this.text);
    }
}

