/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeBoilerFuelBackend
extends RecipeMapBackend {
    private static boolean addedGeneralDesc = false;
    private static final List<String> ALLOWED_SOLID_FUELS = Arrays.asList("gregtech:gt.blockreinforced:6", "gregtech:gt.blockreinforced:7");

    public LargeBoilerFuelBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    public static boolean isAllowedSolidFuel(ItemStack stack) {
        return LargeBoilerFuelBackend.isAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
    }

    public static boolean isAllowedSolidFuel(String itemRegistryName, int meta) {
        return ALLOWED_SOLID_FUELS.contains(itemRegistryName + ":" + meta);
    }

    public static boolean addAllowedSolidFuel(ItemStack stack) {
        return LargeBoilerFuelBackend.addAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
    }

    public static boolean addAllowedSolidFuel(String itemregistryName, int meta) {
        return ALLOWED_SOLID_FUELS.add(itemregistryName + ":" + meta);
    }

    public GTRecipe addDenseLiquidRecipe(GTRecipe recipe) {
        return this.addRecipe(recipe, (double)recipe.mSpecialValue / 10.0, true, false);
    }

    public GTRecipe addDieselRecipe(GTRecipe recipe) {
        return this.addRecipe(recipe, (double)recipe.mSpecialValue / 40.0, true, false);
    }

    public void addSolidRecipes(ItemStack ... itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            this.addSolidRecipe(itemStack);
        }
    }

    @Nullable
    public GTRecipe addSolidRecipe(@Nullable ItemStack fuelItemStack) {
        if (fuelItemStack == null) {
            return null;
        }
        if (GTModHandler.getFuelValue(fuelItemStack) < 400) {
            return null;
        }
        if (!addedGeneralDesc) {
            GTValues.RA.stdBuilder().duration(1).eut(1).specialValue(1).setNEIDesc("Not all solid fuels are listed.", "Any burnable item with a burn", "time of at least 400 / 1000", "will burn in a Large Bronze", "/ Steel Boiler, respectively.").build().map(this::compileRecipe);
            addedGeneralDesc = true;
        }
        boolean isAllowedInSteelBoiler = GTModHandler.getFuelValue(fuelItemStack) >= 1000;
        String registryName = Item.field_150901_e.func_148750_c((Object)fuelItemStack.func_77973_b());
        boolean isHighTierAllowed = ALLOWED_SOLID_FUELS.contains(registryName + ":" + fuelItemStack.func_77960_j());
        return GTValues.RA.stdBuilder().itemInputs(fuelItemStack).duration(1).eut(0).specialValue(GTModHandler.getFuelValue(fuelItemStack) / 1600).build().map(r -> this.addRecipe((GTRecipe)r, (double)GTModHandler.getFuelValue(fuelItemStack) / 1600.0, isAllowedInSteelBoiler, isHighTierAllowed)).orElse(null);
    }

    private GTRecipe addRecipe(GTRecipe recipe, double baseBurnTime, boolean isAllowedInSteelBoiler, boolean isHighTierAllowed) {
        double floatErrorCorrection = 1.0E-4;
        double bronzeBurnTime = baseBurnTime * 2.0 + floatErrorCorrection;
        bronzeBurnTime -= bronzeBurnTime % 0.05;
        double steelBurnTime = baseBurnTime + floatErrorCorrection;
        steelBurnTime -= steelBurnTime % 0.05;
        double titaniumBurnTime = baseBurnTime * 0.3 + floatErrorCorrection;
        titaniumBurnTime -= titaniumBurnTime % 0.05;
        double tungstensteelBurnTime = baseBurnTime * 0.15 + floatErrorCorrection;
        tungstensteelBurnTime -= tungstensteelBurnTime % 0.05;
        recipe.setNeiDesc("Burn time in seconds:", String.format("Bronze Boiler: %.4f", bronzeBurnTime), "Steel Boiler: " + (isAllowedInSteelBoiler ? String.format("%.4f", steelBurnTime) : "Not allowed"), "Titanium Boiler: " + (isHighTierAllowed ? String.format("%.4f", titaniumBurnTime) : "Not allowed"), "Tungstenst. Boiler: " + (isHighTierAllowed ? String.format("%.4f", tungstensteelBurnTime) : "Not allowed"));
        return this.compileRecipe(recipe);
    }
}

