/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class StatHandler {
    public static final Map<Class<? extends Entity>, EntityList.EntityEggInfo> ADDITIONAL_ENTITY_EGGS = new HashMap<Class<? extends Entity>, EntityList.EntityEggInfo>();
    public static String currentEntityName;
    private static final StatBase[] STATS_MINE;
    private static final StatBase[] STATS_CRAFT;
    private static final StatBase[] STATS_USE;
    private static final StatBase[] STATS_BREAK;
    private static boolean initFrozenStats;

    public static void remap(ImmutableList<FMLModIdMappingEvent.ModRemapping> remappedIds) {
        if (initFrozenStats) {
            StatHandler.arraycopy(StatList.field_75934_C, STATS_MINE);
            StatHandler.arraycopy(StatList.field_75928_D, STATS_CRAFT);
            StatHandler.arraycopy(StatList.field_75929_E, STATS_USE);
            StatHandler.arraycopy(StatList.field_75930_F, STATS_BREAK);
            initFrozenStats = false;
        }
        if (remappedIds.isEmpty()) {
            StatHandler.arraycopy(STATS_MINE, StatList.field_75934_C);
            StatHandler.arraycopy(STATS_CRAFT, StatList.field_75928_D);
            StatHandler.arraycopy(STATS_USE, StatList.field_75929_E);
            StatHandler.arraycopy(STATS_BREAK, StatList.field_75930_F);
            return;
        }
        StatBase[] statsMine = (StatBase[])StatList.field_75934_C.clone();
        StatBase[] statsCraft = (StatBase[])StatList.field_75928_D.clone();
        StatBase[] statsUse = (StatBase[])StatList.field_75929_E.clone();
        StatBase[] statsBreak = (StatBase[])StatList.field_75930_F.clone();
        for (FMLModIdMappingEvent.ModRemapping remapping : remappedIds) {
            if (remapping.remapTarget == FMLModIdMappingEvent.RemapTarget.BLOCK) continue;
            int newId = remapping.newId;
            int oldId = remapping.oldId;
            if (newId < 4096 && oldId < 4096) {
                statsMine[newId] = StatList.field_75934_C[oldId];
            } else if (newId < 4096 ^ oldId < 4096) {
                Common.log.warn("Unexpected remap: oldID={}, newId={}, tag={}", new Object[]{oldId, newId, remapping.tag});
            }
            statsCraft[newId] = StatList.field_75928_D[oldId];
            statsUse[newId] = StatList.field_75929_E[oldId];
            statsBreak[newId] = StatList.field_75930_F[oldId];
        }
        StatHandler.arraycopy(statsMine, StatList.field_75934_C);
        StatHandler.arraycopy(statsCraft, StatList.field_75928_D);
        StatHandler.arraycopy(statsUse, StatList.field_75929_E);
        StatHandler.arraycopy(statsBreak, StatList.field_75930_F);
    }

    public static void addEntityStats() {
        if (!ADDITIONAL_ENTITY_EGGS.isEmpty()) {
            return;
        }
        HashSet excludedEntities = Sets.newHashSet((Object[])TweaksConfig.entityStatsExclusions);
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            excludedEntities.add("SnowMan");
            excludedEntities.add("VillagerGolem");
        }
        for (Map.Entry e : EntityList.field_75626_c.entrySet()) {
            Class clazz = (Class)e.getKey();
            if (!EntityLivingBase.class.isAssignableFrom(clazz) || excludedEntities.contains(currentEntityName = (String)e.getValue()) || StatList.func_151177_a((String)("stat.killEntity." + currentEntityName)) != null || StatList.func_151177_a((String)("stat.entityKilledBy." + currentEntityName)) != null) continue;
            ADDITIONAL_ENTITY_EGGS.put(clazz, new EntityInfo(EntityList.field_75624_e.getOrDefault(clazz, 256), currentEntityName));
        }
        currentEntityName = null;
        MinecraftForge.EVENT_BUS.register((Object)new StatHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Entity attackingEntity;
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (entityLivingBase instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityLivingBase;
            attackingEntity = player.func_94060_bK();
            if (attackingEntity == null) {
                return;
            }
            EntityList.EntityEggInfo info = ADDITIONAL_ENTITY_EGGS.get(attackingEntity.getClass());
            if (info == null) {
                return;
            }
            player.func_71064_a(info.field_151513_e, 1);
            return;
        }
        attackingEntity = event.source.func_76346_g();
        if (attackingEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attackingEntity;
            EntityList.EntityEggInfo info = ADDITIONAL_ENTITY_EGGS.get(event.entityLiving.getClass());
            if (info == null) {
                return;
            }
            player.func_71064_a(info.field_151512_d, 1);
        }
    }

    public static StatBase checkBounds(StatBase[] array, int index, StatCrafting statcrafting) {
        if (index < 0 || index >= array.length) {
            String name;
            Item item = statcrafting.func_150959_a();
            String string = name = item == null ? "null" : item.delegate.name();
            if (index == -1) {
                Common.log.warn("Caught out-of-bounds item ID {} for stat {} of item {}", new Object[]{index, statcrafting.field_75975_e, name});
                Common.log.info("You can ignore this warning if {} is not installed on the server!", new Object[]{name.split(":")[0]});
                return null;
            }
            Common.log.error("Caught out-of-bounds item ID {} for stat {} of item {}", new Object[]{index, statcrafting.field_75975_e, name});
            return null;
        }
        return array[index];
    }

    private static <T> void arraycopy(T[] src, T[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    static {
        STATS_MINE = new StatBase[StatList.field_75934_C.length];
        STATS_CRAFT = new StatBase[StatList.field_75928_D.length];
        STATS_USE = new StatBase[StatList.field_75929_E.length];
        STATS_BREAK = new StatBase[StatList.field_75930_F.length];
        initFrozenStats = true;
    }

    public static class EntityInfo
    extends EntityList.EntityEggInfo {
        public final String name;

        public EntityInfo(int id, String name) {
            super(id, 0, 0);
            this.name = name;
        }
    }
}

