/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.block;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.util.CoordsUtils;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockSleepingBag
extends BlockDirectional {
    private static final int[][] footBlockToHeadBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    private static final String TAG_STORED_SPAWN = "storedSpawn";
    private static final String TAG_SPAWN_POS_X = "posX";
    private static final String TAG_SPAWN_POS_Y = "posY";
    private static final String TAG_SPAWN_POS_Z = "posZ";
    @SideOnly(value=Side.CLIENT)
    private IIcon[] endIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] sideIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] topIcons;

    public BlockSleepingBag() {
        super(Material.field_151580_n);
        this.func_149978_e();
        this.func_149663_c(this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_149641_N() {
        return this.field_149768_d == null ? "MISSING_ICON_BLOCK_" + BlockSleepingBag.func_149682_b((Block)this) + "_" + this.func_149739_a() : this.field_149768_d;
    }

    public String func_149739_a() {
        return "blockSleepingBag";
    }

    private void func_149978_e() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
    }

    private static boolean isBlockHeadOfBed(int meta) {
        return (meta & 8) != 0;
    }

    public static boolean isSleepingInPortableBag(EntityPlayer player) {
        return Wearing.isWearingBackpack(player) && Wearing.getWearingBackpackInv(player).getExtendedProperties().func_74764_b("sleepingInBag");
    }

    public static void packPortableSleepingBag(EntityPlayer player) {
        if (BlockSleepingBag.isSleepingInPortableBag(player)) {
            InventoryBackpack inv = Wearing.getWearingBackpackInv(player);
            inv.removeSleepingBag(player.field_70170_p);
            inv.getExtendedProperties().func_82580_o("sleepingInBag");
        }
    }

    public static void storeOriginalSpawn(EntityPlayer player, NBTTagCompound tag) {
        ChunkCoordinates spawn = player.getBedLocation(player.field_70170_p.field_73011_w.field_76574_g);
        if (spawn != null) {
            NBTTagCompound storedSpawn = new NBTTagCompound();
            storedSpawn.func_74768_a(TAG_SPAWN_POS_X, spawn.field_71574_a);
            storedSpawn.func_74768_a(TAG_SPAWN_POS_Y, spawn.field_71572_b);
            storedSpawn.func_74768_a(TAG_SPAWN_POS_Z, spawn.field_71573_c);
            tag.func_74782_a(TAG_STORED_SPAWN, (NBTBase)storedSpawn);
            LogHelper.info("Stored spawn data for " + player.getDisplayName() + ": " + spawn + " dimID: " + player.field_70170_p.field_73011_w.field_76574_g);
        } else {
            LogHelper.warn("Cannot store spawn data for " + player.getDisplayName());
        }
    }

    public static void restoreOriginalSpawn(EntityPlayer player, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_STORED_SPAWN)) {
            NBTTagCompound storedSpawn = tag.func_74775_l(TAG_STORED_SPAWN);
            ChunkCoordinates coords = new ChunkCoordinates(storedSpawn.func_74762_e(TAG_SPAWN_POS_X), storedSpawn.func_74762_e(TAG_SPAWN_POS_Y), storedSpawn.func_74762_e(TAG_SPAWN_POS_Z));
            player.setSpawnChunk(coords, false, player.field_70170_p.field_73011_w.field_76574_g);
            tag.func_82580_o(TAG_STORED_SPAWN);
            LogHelper.info("Restored spawn data for " + player.getDisplayName() + ": " + coords + " dimID: " + player.field_70170_p.field_73011_w.field_76574_g);
        } else {
            LogHelper.warn("No spawn data to restore for " + player.getDisplayName());
        }
    }

    public void onPortableBlockActivated(World world, EntityPlayer player, int cX, int cY, int cZ) {
        if (world.field_72995_K) {
            return;
        }
        if (!BlockSleepingBag.isSleepingInPortableBag(player)) {
            return;
        }
        if (!this.func_149727_a(world, cX, cY, cZ, player, 1, 0.0f, 0.0f, 0.0f)) {
            BlockSleepingBag.packPortableSleepingBag(player);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int id, float f1, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        if (!BlockSleepingBag.isBlockHeadOfBed(meta)) {
            int dir = BlockSleepingBag.func_149895_l((int)meta);
            if (world.func_147439_a(x += footBlockToHeadBlockMap[dir][0], y, z += footBlockToHeadBlockMap[dir][1]) != this) {
                return false;
            }
            meta = world.func_72805_g(x, y, z);
        }
        if (world.field_73011_w.func_76567_e() && world.func_72807_a(x, z) != BiomeGenBase.field_76778_j) {
            EntityPlayer.EnumStatus enumstatus;
            if (BlockSleepingBag.isBedOccupied(meta)) {
                EntityPlayer entityplayer1 = null;
                for (Object o : world.field_73010_i) {
                    EntityPlayer entityplayer2 = (EntityPlayer)o;
                    if (!entityplayer2.func_70608_bn()) continue;
                    ChunkCoordinates chunkcoordinates = entityplayer2.field_71081_bT;
                    if (chunkcoordinates.field_71574_a != x || chunkcoordinates.field_71572_b != y || chunkcoordinates.field_71573_c != z) continue;
                    entityplayer1 = entityplayer2;
                }
                if (entityplayer1 != null) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.occupied", new Object[0]));
                    return false;
                }
                BlockSleepingBag.setBedOccupied(world, x, y, z, false);
            }
            if ((enumstatus = player.func_71018_a(x, y, z)) == EntityPlayer.EnumStatus.OK) {
                BlockSleepingBag.setBedOccupied(world, x, y, z, true);
                if (BlockSleepingBag.isSleepingInPortableBag(player)) {
                    BlockSleepingBag.storeOriginalSpawn(player, Wearing.getWearingBackpackInv(player).getExtendedProperties());
                    player.setSpawnChunk(new ChunkCoordinates(x, y, z), true, player.field_71093_bK);
                } else {
                    player.setSpawnChunk(new ChunkCoordinates(x, y, z), true, player.field_71093_bK);
                    LogHelper.info("Looking for a campfire nearby...");
                    ChunkCoordinates campfire = CoordsUtils.findBlock3D(world, x, y, z, (Block)ModBlocks.blockCampFire, 8, 2);
                    if (campfire != null) {
                        LogHelper.info("Campfire Found, saving coordinates. " + campfire);
                        BackpackProperty.get(player).setCampFire(campfire);
                    }
                }
                return true;
            }
            if (enumstatus == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
            } else if (enumstatus == EntityPlayer.EnumStatus.NOT_SAFE) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
            }
            return false;
        }
        double d2 = (double)x + 0.5;
        double d0 = (double)y + 0.5;
        double d1 = (double)z + 0.5;
        world.func_147468_f(x, y, z);
        int k1 = BlockSleepingBag.func_149895_l((int)meta);
        if (world.func_147439_a(x += footBlockToHeadBlockMap[k1][0], y, z += footBlockToHeadBlockMap[k1][1]) == this) {
            world.func_147468_f(x, y, z);
            d2 = (d2 + (double)x + 0.5) / 2.0;
            d0 = (d0 + (double)y + 0.5) / 2.0;
            d1 = (d1 + (double)z + 0.5) / 2.0;
        }
        world.func_72885_a(null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 5.0f, true, true);
        return false;
    }

    private static void setBedOccupied(World world, int x, int y, int z, boolean flag) {
        int l = world.func_72805_g(x, y, z);
        l = flag ? (l |= 4) : (l &= 0xFFFFFFFB);
        world.func_72921_c(x, y, z, l, 4);
    }

    private static boolean isBedOccupied(int meta) {
        return (meta & 4) != 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        int dir = BlockSleepingBag.func_149895_l((int)meta);
        if (BlockSleepingBag.isBlockHeadOfBed(meta)) {
            if (world.func_147439_a(x - footBlockToHeadBlockMap[dir][0], y, z - footBlockToHeadBlockMap[dir][1]) != this) {
                world.func_147468_f(x, y, z);
            }
        } else if (world.func_147439_a(x + footBlockToHeadBlockMap[dir][0], y, z + footBlockToHeadBlockMap[dir][1]) != this) {
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, meta, 0);
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.blockBoundsForRender();
    }

    private void blockBoundsForRender() {
        this.func_149978_e();
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        int direction = BlockSleepingBag.func_149895_l((int)meta);
        if (player.field_71075_bZ.field_75098_d && BlockSleepingBag.isBlockHeadOfBed(meta) && world.func_147439_a(x -= footBlockToHeadBlockMap[direction][0], y, z -= footBlockToHeadBlockMap[direction][1]) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion boom) {
        this.func_149664_b(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        int direction = BlockSleepingBag.func_149895_l((int)meta);
        int tileZ = z;
        int tileX = x;
        switch (meta) {
            case 0: {
                --tileZ;
                break;
            }
            case 1: {
                ++tileX;
                break;
            }
            case 2: {
                ++tileZ;
                break;
            }
            case 3: {
                --tileX;
            }
        }
        if (world.func_147438_o(tileX, y, tileZ) != null && world.func_147438_o(tileX, y, tileZ) instanceof TileAdventureBackpack) {
            ((TileAdventureBackpack)world.func_147438_o(tileX, y, tileZ)).setSleepingBagDeployed(false);
        }
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int isHead;
        if (side == 0) {
            return Blocks.field_150344_f.func_149733_h(side);
        }
        int k = BlockSleepingBag.func_149895_l((int)meta);
        int l = Direction.field_71584_h[k][side];
        int n = isHead = BlockSleepingBag.isBlockHeadOfBed(meta) ? 1 : 0;
        return !(isHead == 1 && l == 2 || isHead == 0 && l == 3) ? (l != 5 && l != 4 ? this.topIcons[isHead] : this.sideIcons[isHead]) : this.endIcons[isHead];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcons = new IIcon[]{iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_feet_top").toString()), iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_head_top").toString())};
        this.endIcons = new IIcon[]{iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_feet_end").toString()), iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_head_end").toString())};
        this.sideIcons = new IIcon[]{iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_feet_side").toString()), iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_head_side").toString())};
    }

    public int func_149645_b() {
        return 14;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }
}

