/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.DataTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxAnalogController
extends TileBoxBase
implements IControllerTile,
IGuiReturnHandler {
    private final SimpleSignalController controller = new SimpleSignalController(this.getLocalizationTag(), this);
    private int strongestSignal;
    public EnumMap<SignalAspect, BitSet> aspects = new EnumMap(SignalAspect.class);

    public TileBoxAnalogController() {
        for (SignalAspect aspect : SignalAspect.VALUES) {
            this.aspects.put(aspect, new BitSet());
        }
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_ANALOG_CONTROLLER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        GuiHandler.openGui(EnumGui.BOX_ANALOG_CONTROLLER, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            this.controller.tickClient();
            return;
        }
        this.controller.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.controller.isPaired()) {
            this.controller.setAspect(this.determineAspect());
        } else {
            this.controller.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        int s = this.getPowerLevel();
        if (s != this.strongestSignal) {
            this.strongestSignal = s;
            this.sendUpdateToClient();
        }
    }

    private int getPowerLevel() {
        int p = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == ForgeDirection.UP || this.tileCache.getTileOnSide(side) instanceof TileBoxBase) continue;
            int tmp = PowerPlugin.getBlockPowerLevel(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
            if (tmp > p) {
                p = tmp;
            }
            if ((tmp = PowerPlugin.getBlockPowerLevel(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, side)) <= p) continue;
            p = tmp;
        }
        return p;
    }

    private SignalAspect determineAspect() {
        SignalAspect aspect = SignalAspect.OFF;
        for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
            SignalAspect current = entry.getKey();
            if (!entry.getValue().get(this.strongestSignal)) continue;
            aspect = aspect == SignalAspect.OFF ? current : SignalAspect.mostRestrictive(aspect, current);
        }
        return aspect;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("strongestSignal", this.strongestSignal);
        for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
            String n = entry.getKey().name();
            byte[] bytes = new byte[2];
            DataTools.bitSet2ByteArray(entry.getValue(), bytes);
            data.func_74773_a("aspect_" + n, bytes);
        }
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        String n;
        super.func_145839_a(data);
        this.strongestSignal = data.func_74762_e("strongestSignal");
        try {
            for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
                n = entry.getKey().name();
                byte[] bytes = data.func_74770_j("aspect_" + n);
                DataTools.byteArray2BitSet(entry.getValue(), bytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.controller.readFromNBT(data);
        for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
            n = entry.getKey().toString();
            boolean on = data.func_74767_n("mode" + n);
            if (!on) continue;
            int low = data.func_74762_e("low" + n);
            int high = data.func_74762_e("high" + n);
            entry.getValue().set(low, high);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.writeGuiData(data);
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.readGuiData(data, null);
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
            byte[] bytes = new byte[2];
            DataTools.bitSet2ByteArray(entry.getValue(), bytes);
            data.write(bytes);
        }
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        for (Map.Entry<SignalAspect, BitSet> entry : this.aspects.entrySet()) {
            byte[] bytes = new byte[2];
            data.read(bytes);
            DataTools.byteArray2BitSet(entry.getValue(), bytes);
        }
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.controller.getAspect();
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }
}

