/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.compatability;

import codechicken.nei.api.API;
import com.InfinityRaider.AgriCraft.api.v3.APIv3;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import de.keridos.floodlights.compatability.IGWHandler;
import de.keridos.floodlights.compatability.IGWSupportNotifier;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.util.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ModCompatibility {
    private static ModCompatibility instance = null;
    public IGWHandler igwHandler = null;
    public static boolean IC2Loaded = false;
    public static boolean IGWModLoaded = false;
    public static boolean BCLoaded = false;
    public static boolean CofhCoreLoaded = false;
    public static boolean NEILoaded = false;
    public static boolean EnderIOLoaded = false;
    public static boolean WrenchAvailable = false;
    public static boolean ColoredLightCoreLoaded = false;
    public static boolean ACLoaded = false;

    private ModCompatibility() {
    }

    public static ModCompatibility getInstance() {
        if (instance == null) {
            instance = new ModCompatibility();
        }
        return instance;
    }

    private void checkForMods() {
        IC2Loaded = Loader.isModLoaded((String)"IC2");
        IGWModLoaded = Loader.isModLoaded((String)"IGWMod");
        BCLoaded = ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|tools");
        CofhCoreLoaded = ModAPIManager.INSTANCE.hasAPI("CoFHAPI|item");
        NEILoaded = Loader.isModLoaded((String)"NotEnoughItems");
        EnderIOLoaded = Loader.isModLoaded((String)"EnderIO");
        ColoredLightCoreLoaded = Loader.isModLoaded((String)"coloredlightcore");
        ACLoaded = Loader.isModLoaded((String)"AgriCraft");
    }

    @Optional.Method(modid="NotEnoughItems")
    private void hideNEIItems() {
        API.hideItem((ItemStack)new ItemStack(ModBlocks.blockPhantomLight));
        API.hideItem((ItemStack)new ItemStack(ModBlocks.blockUVLightBlock));
    }

    private void addVersionCheckerInfo() {
        NBTTagCompound versionchecker = new NBTTagCompound();
        versionchecker.func_74778_a("curseProjectName", "224728-floodlights");
        versionchecker.func_74778_a("curseFilenameParser", "FloodLights-1.7.10-[]");
        versionchecker.func_74778_a("modDisplayName", "FloodLights");
        versionchecker.func_74778_a("oldVersion", "1.2.9");
        FMLInterModComms.sendRuntimeMessage((Object)"floodlights", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)versionchecker);
    }

    public void performModCompat() {
        this.checkForMods();
        if (ConfigHandler.IGWNotifierEnabled) {
            new IGWSupportNotifier();
        }
        if (NEILoaded) {
            this.hideNEIItems();
        }
        this.addVersionCheckerInfo();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"de.keridos.floodlights.compatability.WailaTileHandler.callbackRegister");
        WrenchAvailable = BCLoaded || EnderIOLoaded || IC2Loaded || CofhCoreLoaded;
    }

    @Optional.Method(modid="AgriCraft")
    public boolean isBlockValidAgriCraftSeed(Block block, World world, BlockPos blockPos) {
        return block instanceof ICrop && ((APIv3)com.InfinityRaider.AgriCraft.api.API.getAPI((int)3)).getCrop(world, blockPos.posX, blockPos.posY, blockPos.posZ).hasPlant() && ((APIv3)com.InfinityRaider.AgriCraft.api.API.getAPI((int)3)).getCrop(world, blockPos.posX, blockPos.posY, blockPos.posZ).getPlant().getGrowthRequirement().canGrow(world, blockPos.posX, blockPos.posY, blockPos.posZ);
    }
}

