/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.factory.FactoryBackpack;
import de.eydamos.backpack.inventory.ISaveableInventory;
import de.eydamos.backpack.inventory.InventoryBasic;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.util.NBTUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class MessageOpenBackpack
implements IMessage,
IMessageHandler<MessageOpenBackpack, IMessage> {
    protected String uuid;
    protected byte type;
    protected int slotsPerRow = 9;
    protected String name;
    protected boolean customName;
    protected int size;
    protected int windowId = 0;
    protected boolean intelligent = false;

    public MessageOpenBackpack() {
    }

    public MessageOpenBackpack(BackpackSave backpack, IInventory inventory, int windowID) {
        if (inventory instanceof ISaveableInventory) {
            ((ISaveableInventory)inventory).readFromNBT(backpack);
        }
        this.uuid = backpack.getUUID();
        this.type = backpack.getType();
        this.slotsPerRow = backpack.getSlotsPerRow();
        this.name = inventory.func_145825_b();
        this.customName = inventory.func_145818_k_();
        this.size = inventory.func_70302_i_();
        this.windowId = windowID;
        this.intelligent = backpack.isIntelligent();
    }

    public void fromBytes(ByteBuf buffer) {
        this.windowId = buffer.readInt();
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.type = buffer.readByte();
        this.slotsPerRow = buffer.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.customName = buffer.readBoolean();
        this.size = buffer.readInt();
        this.intelligent = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.windowId);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.uuid);
        buffer.writeByte((int)this.type);
        buffer.writeInt(this.slotsPerRow);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.writeBoolean(this.customName);
        buffer.writeInt(this.size);
        buffer.writeBoolean(this.intelligent);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageOpenBackpack message, MessageContext ctx) {
        EntityClientPlayerMP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        InventoryBasic backpackInventory = new InventoryBasic(message.name, message.customName, message.size);
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTUtil.setString(nbtTagCompound, "backpack-UID", message.uuid);
        NBTUtil.setByte(nbtTagCompound, "type", message.type);
        NBTUtil.setInteger(nbtTagCompound, "slotsPerRow", message.slotsPerRow);
        NBTUtil.setBoolean(nbtTagCompound, "intelligent", message.intelligent);
        BackpackSave backpackSave = new BackpackSave(nbtTagCompound);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)FactoryBackpack.getGuiContainer(backpackSave, new IInventory[]{entityPlayer.field_71071_by, backpackInventory}, (EntityPlayer)entityPlayer));
        entityPlayer.field_71070_bA.field_75152_c = message.windowId;
        return null;
    }
}

