/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.MapSaver;
import journeymap.client.log.ChatLog;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.BooleanPropertyButton;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.AutoMapConfirmation;
import journeymap.client.ui.dialog.DeleteMapConfirmation;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.gui.GuiButton;
import org.apache.logging.log4j.Level;

public class FullscreenActions
extends JmUI {
    protected TextureImpl patreonLogo = TextureCache.instance().getPatreonLogo();
    Button buttonAutomap;
    Button buttonSave;
    Button buttonAbout;
    Button buttonClose;
    Button buttonBrowser;
    Button buttonCheck;
    Button buttonDonate;
    Button buttonDeleteMap;
    BooleanPropertyButton buttonEnableMapping;

    public FullscreenActions() {
        super(Constants.getString("jm.common.actions"));
    }

    public FullscreenActions(JmUI returnDisplay) {
        super(Constants.getString("jm.common.actions"), returnDisplay);
    }

    public static void launchLocalhost() {
        String url = "http://localhost:" + JourneymapClient.getWebMapProperties().port.get();
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            Journeymap.getLogger().log(Level.ERROR, "Could not launch browser with URL: " + url + ": " + LogFormatter.toString(e));
        }
    }

    public static void launchPatreon() {
        String url = "http://patreon.com/techbrew";
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            Journeymap.getLogger().log(Level.ERROR, "Could not launch browser with URL: " + url + ": " + LogFormatter.toString(e));
        }
    }

    public static void launchWebsite() {
        String url = "http://minecraft.curseforge.com/projects/journeymap-32274/files/";
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Could not launch browser with URL: " + url, new Object[]{LogFormatter.toString(e)});
        }
    }

    public static void launchDownloadWebsite() {
        String url = VersionCheck.getDownloadUrl();
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Could not launch browser with URL: " + url, new Object[]{LogFormatter.toString(e)});
        }
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.buttonAbout = new Button(Constants.getString("jm.common.splash_about"));
        this.buttonSave = new Button(Constants.getString("jm.common.save_map"));
        this.buttonClose = new Button(Constants.getString("jm.common.close"));
        this.buttonBrowser = new Button(Constants.getString("jm.common.use_browser"));
        this.buttonBrowser.setEnabled(JourneymapClient.getWebMapProperties().enabled.get());
        this.buttonAutomap = new Button(Constants.getString("jm.common.automap_title"));
        this.buttonAutomap.setTooltip(Constants.getString("jm.common.automap_text"));
        this.buttonAutomap.setEnabled(ForgeHelper.INSTANCE.getClient().func_71356_B() && JourneymapClient.getCoreProperties().mappingEnabled.get());
        this.buttonDeleteMap = new Button(Constants.getString("jm.common.deletemap_title"));
        this.buttonDeleteMap.setTooltip(Constants.getString("jm.common.deletemap_text"));
        this.buttonDonate = new Button(Constants.getString("jm.webmap.donate_text"));
        this.buttonDonate.setDefaultStyle(false);
        this.buttonDonate.setDrawBackground(false);
        this.buttonDonate.setDrawFrame(false);
        this.buttonCheck = new Button(Constants.getString("jm.common.update_check"));
        this.buttonEnableMapping = new BooleanPropertyButton(Constants.getString("jm.common.enable_mapping_false"), Constants.getString("jm.common.enable_mapping_true"), JourneymapClient.getCoreProperties(), JourneymapClient.getCoreProperties().mappingEnabled);
        this.field_146292_n.add(this.buttonAbout);
        this.field_146292_n.add(this.buttonAutomap);
        this.field_146292_n.add(this.buttonSave);
        this.field_146292_n.add(this.buttonCheck);
        this.field_146292_n.add(this.buttonDonate);
        this.field_146292_n.add(this.buttonBrowser);
        this.field_146292_n.add(this.buttonDeleteMap);
        this.field_146292_n.add(this.buttonEnableMapping);
        new ButtonList(this.field_146292_n).equalizeWidths(this.getFontRenderer());
        this.field_146292_n.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        this.buttonSave.setEnabled(!JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class));
        int hgap = 4;
        int vgap = 3;
        int bx = this.field_146294_l / 2;
        int by = this.field_146295_m / 4;
        this.buttonAbout.centerHorizontalOn(bx).setY(by);
        by = this.buttonAbout.getBottomY() + 3;
        ButtonList row1 = new ButtonList(this.buttonAutomap, this.buttonEnableMapping);
        ButtonList row2 = new ButtonList(this.buttonSave, this.buttonDeleteMap);
        ButtonList row3 = new ButtonList(this.buttonBrowser, this.buttonCheck);
        row1.layoutCenteredHorizontal(bx, by, true, 4);
        row2.layoutCenteredHorizontal(bx, row1.getBottomY() + 3, true, 4);
        row3.layoutCenteredHorizontal(bx, row2.getBottomY() + 3, true, 4);
        int patreonX = bx - 8;
        int patreonY = row2.getBottomY() + 32;
        DrawUtil.drawImage(this.patreonLogo, patreonX, patreonY, false, 0.5f, 0.0);
        this.buttonDonate.centerHorizontalOn(bx).setY(patreonY + 16);
        this.buttonClose.below(this.buttonDonate, 12).centerHorizontalOn(bx);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.buttonSave) {
            this.save();
            UIManager.getInstance().openFullscreenMap();
            return;
        }
        if (guibutton == this.buttonClose) {
            UIManager.getInstance().openFullscreenMap();
            return;
        }
        if (guibutton == this.buttonBrowser) {
            FullscreenActions.launchLocalhost();
            UIManager.getInstance().openFullscreenMap();
            return;
        }
        if (guibutton == this.buttonDonate) {
            FullscreenActions.launchPatreon();
            UIManager.getInstance().openFullscreenMap();
            return;
        }
        if (guibutton == this.buttonAutomap) {
            UIManager.getInstance().open(AutoMapConfirmation.class);
            return;
        }
        if (guibutton == this.buttonDeleteMap) {
            UIManager.getInstance().open(DeleteMapConfirmation.class);
            return;
        }
        if (guibutton == this.buttonCheck) {
            FullscreenActions.launchWebsite();
            UIManager.getInstance().openFullscreenMap();
            return;
        }
        if (guibutton == this.buttonAbout) {
            UIManager.getInstance().openSplash(this);
            return;
        }
        if (guibutton == this.buttonEnableMapping) {
            this.buttonEnableMapping.toggle();
            if (JourneymapClient.getCoreProperties().mappingEnabled.get()) {
                UIManager.getInstance().openFullscreenMap();
                ChatLog.announceI18N("jm.common.enable_mapping_true_text", new Object[0]);
                return;
            }
            JourneymapClient.getInstance().stopMapping();
            ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            UIManager.getInstance().openFullscreenMap();
            return;
        }
    }

    void save() {
        MapState state = Fullscreen.state();
        boolean showCaves = JourneymapClient.getFullMapProperties().showCaves.get();
        MapType mapType = state.getMapType(showCaves);
        MapSaver mapSaver = new MapSaver(state.getWorldDir(), mapType);
        if (mapSaver.isValid()) {
            JourneymapClient.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
            ChatLog.announceI18N("jm.common.save_filename", mapSaver.getSaveFileName());
        }
        this.closeAndReturn();
    }

    @Override
    protected void func_73869_a(char c, int i) {
        switch (i) {
            case 1: {
                this.closeAndReturn();
            }
        }
    }
}

