/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class TileChestHungryVisitor
extends ClassVisitor {
    public TileChestHungryVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals(LoadingPlugin.dev ? "decrStackSize" : "func_70298_a")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new DecrStackSizeVisitor(this.api, mv);
        }
        return mv;
    }

    private static class DecrStackSizeVisitor
    extends MethodVisitor {
        private boolean added = false;

        public DecrStackSizeVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (opcode == 198) {
                if (this.added) {
                    TC4Transformer.log.error("Unrecognized Thaumcraft class files. Things might not work! Is someone else patching it?");
                    return;
                }
                this.added = true;
                TC4Transformer.log.trace("Adding missing if branch after IFNULL");
                Label lblDynamicContentMarker = new Label();
                this.mv.visitLabel(lblDynamicContentMarker);
                this.mv.visitLineNumber(114514, lblDynamicContentMarker);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileChestHungry", "chestContents", "[Lnet/minecraft/item/ItemStack;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitInsn(50);
                this.mv.visitFieldInsn(180, "net/minecraft/item/ItemStack", LoadingPlugin.dev ? "stackSize" : "field_77994_a", "I");
                this.mv.visitVarInsn(21, 2);
                Label lblNextIfBranch = new Label();
                this.mv.visitJumpInsn(163, lblNextIfBranch);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileChestHungry", "chestContents", "[Lnet/minecraft/item/ItemStack;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileChestHungry", "chestContents", "[Lnet/minecraft/item/ItemStack;");
                this.mv.visitVarInsn(21, 1);
                this.mv.visitInsn(1);
                this.mv.visitInsn(83);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, "thaumcraft/common/tiles/TileChestHungry", LoadingPlugin.dev ? "markDirty" : "func_70296_d", "()V", false);
                this.mv.visitInsn(176);
                this.mv.visitLabel(lblNextIfBranch);
                this.mv.visitFrame(3, 0, null, 0, null);
            }
        }
    }
}

