/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import blockrenderer6343.api.utils.BlockPosition;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;

public class ProjectionUtils {
    private static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();

    public static Vector3f project(BlockPosition pos) {
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluProject((float)((float)pos.x + 0.5f), (float)((float)pos.y + 0.5f), (float)((float)pos.z + 0.5f), (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float winX = OBJECT_POS_BUFFER.get();
        float winY = OBJECT_POS_BUFFER.get();
        float winZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(winX, winY, winZ);
    }

    public static Vector3f unProject(int mouseX, int mouseY) {
        GL11.glReadPixels((int)mouseX, (int)mouseY, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluUnProject((float)mouseX, (float)mouseY, (float)pixelDepth, (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(posX, posY, posZ);
    }
}

