/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.fog;

import biomesoplenty.client.fog.IBiomeFog;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import org.lwjgl.opengl.GL11;

public class FogHandler {
    private static double fogX;
    private static double fogZ;
    private static boolean fogInit;
    private static float fogFarPlaneDistance;

    @SubscribeEvent
    public void onGetFogColour(EntityViewRenderEvent.FogColors event) {
        if (!BOPConfigurationMisc.fogColors) {
            return;
        }
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            World world = player.field_70170_p;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            Block blockAtEyes = ActiveRenderInfo.func_151460_a((World)world, (EntityLivingBase)event.entity, (float)((float)event.renderPartialTicks));
            if (blockAtEyes.func_149688_o() == Material.field_151587_i) {
                return;
            }
            Vec3 mixedColor = blockAtEyes.func_149688_o() == Material.field_151586_h ? FogHandler.getFogBlendColorWater(world, (EntityLivingBase)player, x, y, z, event.renderPartialTicks) : FogHandler.getFogBlendColour(world, (EntityLivingBase)player, x, y, z, event.red, event.green, event.blue, event.renderPartialTicks);
            event.red = (float)mixedColor.field_72450_a;
            event.green = (float)mixedColor.field_72448_b;
            event.blue = (float)mixedColor.field_72449_c;
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        EntityLivingBase entity = event.entity;
        World world = entity.field_70170_p;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if ((double)playerX == fogX && (double)playerZ == fogZ && fogInit) {
            FogHandler.renderFog(event.fogMode, fogFarPlaneDistance, 0.75f);
            return;
        }
        fogInit = true;
        int distance = 20;
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                if (!(biome instanceof IBiomeFog)) continue;
                float distancePart = ((IBiomeFog)biome).getFogDensity(playerX + x, playerY, playerZ + z);
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (entity.field_70165_t - (double)playerX);
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = entity.field_70165_t - (double)playerX;
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (entity.field_70161_v - (double)playerZ);
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = entity.field_70161_v - (double)playerZ;
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += weightPart;
            }
        }
        float weightMixed = distance * 2 * (distance * 2);
        float weightDefault = weightMixed - weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.farPlaneDistance * weightDefault) / weightMixed;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / weightMixed;
        fogX = entity.field_70165_t;
        fogZ = entity.field_70161_v;
        fogFarPlaneDistance = Math.min(farPlaneDistance, event.farPlaneDistance);
        FogHandler.renderFog(event.fogMode, fogFarPlaneDistance, farPlaneDistanceScale);
    }

    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        } else {
            GL11.glFogf((int)2915, (float)(farPlaneDistance * farPlaneDistanceScale));
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        }
    }

    private static Vec3 postProcessColor(World world, EntityLivingBase player, float r, float g, float b, double renderPartialTicks) {
        int duration;
        double darkScale = (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * renderPartialTicks) * world.field_73011_w.func_76565_k();
        if (player.func_70644_a(Potion.field_76440_q)) {
            duration = player.func_70660_b(Potion.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? (double)(1.0f - (float)duration / 20.0f) : 0.0;
        }
        if (darkScale < 1.0) {
            darkScale = darkScale < 0.0 ? 0.0 : darkScale * darkScale;
            r = (float)((double)r * darkScale);
            g = (float)((double)g * darkScale);
            b = (float)((double)b * darkScale);
        }
        if (player.func_70644_a(Potion.field_76439_r)) {
            duration = player.func_70660_b(Potion.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)((float)(((double)duration - renderPartialTicks) * Math.PI * (double)0.2f))) * 0.3f;
            float scale = 1.0f / r;
            scale = Math.min(scale, 1.0f / g);
            scale = Math.min(scale, 1.0f / b);
            r = r * (1.0f - brightness) + r * scale * brightness;
            g = g * (1.0f - brightness) + g * scale * brightness;
            b = b * (1.0f - brightness) + b * scale * brightness;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float aR = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float aG = (r * 30.0f + g * 70.0f) / 100.0f;
            float aB = (r * 30.0f + b * 70.0f) / 100.0f;
            r = aR;
            g = aG;
            b = aB;
        }
        return Vec3.func_72443_a((double)r, (double)g, (double)b);
    }

    private static Vec3 getFogBlendColorWater(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, double renderPartialTicks) {
        int distance = 2;
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                int waterColorMult = biome.field_76759_H;
                float rPart = (waterColorMult & 0xFF0000) >> 16;
                float gPart = (waterColorMult & 0xFF00) >> 8;
                float bPart = waterColorMult & 0xFF;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
            }
        }
        float weight = distance * 2 * (distance * 2);
        float respirationLevel = (float)EnchantmentHelper.func_77501_a((EntityLivingBase)playerEntity) * 0.2f;
        float rMixed = ((rBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float gMixed = ((gBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float bMixed = ((bBiomeFog /= 255.0f) * 0.2f + respirationLevel) / weight;
        return FogHandler.postProcessColor(world, playerEntity, rMixed, gMixed, bMixed, renderPartialTicks);
    }

    private static Vec3 getFogBlendColour(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, float defR, float defG, float defB, double renderPartialTicks) {
        float thunderStrength;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 6;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                if (!(biome instanceof IBiomeFog)) continue;
                IBiomeFog biomeFog = (IBiomeFog)biome;
                int fogColour = biomeFog.getFogColour(playerX + x, playerY, playerZ + z);
                float rPart = (fogColour & 0xFF0000) >> 16;
                float gPart = (fogColour & 0xFF00) >> 8;
                float bPart = fogColour & 0xFF;
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
                weightBiomeFog += weightPart;
            }
        }
        if (weightBiomeFog == 0.0f || distance == 0) {
            return Vec3.func_72443_a((double)defR, (double)defG, (double)defB);
        }
        rBiomeFog /= 255.0f;
        gBiomeFog /= 255.0f;
        bBiomeFog /= 255.0f;
        float celestialAngle = world.func_72826_c((float)renderPartialTicks);
        float baseScale = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float rScale = baseScale * 0.94f + 0.06f;
        float gScale = baseScale * 0.94f + 0.06f;
        float bScale = baseScale * 0.91f + 0.09f;
        float rainStrength = world.func_72867_j((float)renderPartialTicks);
        if (rainStrength > 0.0f) {
            rScale *= 1.0f - rainStrength * 0.5f;
            gScale *= 1.0f - rainStrength * 0.5f;
            bScale *= 1.0f - rainStrength * 0.4f;
        }
        if ((thunderStrength = world.func_72819_i((float)renderPartialTicks)) > 0.0f) {
            rScale *= 1.0f - thunderStrength * 0.5f;
            gScale *= 1.0f - thunderStrength * 0.5f;
            bScale *= 1.0f - thunderStrength * 0.5f;
        }
        Vec3 processedColor = FogHandler.postProcessColor(world, playerEntity, rBiomeFog *= rScale / weightBiomeFog, gBiomeFog *= gScale / weightBiomeFog, bBiomeFog *= bScale / weightBiomeFog, renderPartialTicks);
        rBiomeFog = (float)processedColor.field_72450_a;
        gBiomeFog = (float)processedColor.field_72448_b;
        bBiomeFog = (float)processedColor.field_72449_c;
        float weightMixed = distance * 2 * (distance * 2);
        float weightDefault = weightMixed - weightBiomeFog;
        processedColor.field_72450_a = (rBiomeFog * weightBiomeFog + defR * weightDefault) / weightMixed;
        processedColor.field_72448_b = (gBiomeFog * weightBiomeFog + defG * weightDefault) / weightMixed;
        processedColor.field_72449_c = (bBiomeFog * weightBiomeFog + defB * weightDefault) / weightMixed;
        return processedColor;
    }
}

