/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.worldgen.BlockType;
import binnie.extratrees.worldgen.BlockTypeLeaf;
import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenShrub
extends WorldGenTree {
    public WorldGenShrub(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        float leafSpawn = this.height;
        float width = (float)this.height * this.randBetween(0.7f, 0.9f);
        if (width < 1.5f) {
            width = 1.5f;
        }
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
        float f2 = leafSpawn;
        leafSpawn = f2 - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.8f * width, 1, this.leaf, false);
        while (leafSpawn >= 0.0f) {
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.minHeight = 1;
        this.height = this.determineHeight(1, 1);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getLeaf() {
        return new BlockTypeLeaf(false);
    }
}

