/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.Mods;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.block.IFenceProvider;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.WoodManager;
import extrabiomes.api.Stuff;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class PlankType {
    public static void setup() {
        for (VanillaPlanks vanillaPlanks : VanillaPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(vanillaPlanks.ordinal(), vanillaPlanks);
        }
        for (Enum enum_ : ExtraTreePlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 32, (IDesignMaterial)((Object)enum_));
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 128, (IDesignMaterial)((Object)enum_));
        }
        for (Enum enum_ : ExtraBiomesPlank.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 192, (IDesignMaterial)((Object)enum_));
        }
    }

    public static enum ExtraBiomesPlank implements IPlankType
    {
        Redwood(10185538),
        Fir(8288074),
        Acacia(12561022);

        protected int color;

        private ExtraBiomesPlank(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return I18N.localise("extratrees.block.planks.ebxl." + this.toString().toLowerCase());
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks.ebxl." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ItemStack getStack() {
            if (!Mods.extraBiomes.active()) {
                return null;
            }
            return (ItemStack)Stuff.planks.transform(block -> new ItemStack(block, 1, this.ordinal())).orNull();
        }

        @Override
        public IIcon getIcon() {
            if (this.getStack() != null) {
                int meta = this.getStack().func_77960_j();
                Block block = ((ItemBlock)this.getStack().func_77973_b()).field_150939_a;
                return block.func_149691_a(2, meta);
            }
            return null;
        }
    }

    public static enum ForestryPlanks implements IPlankType,
    IFenceProvider
    {
        LARCH(14131085),
        TEAK(8223075),
        ACACIA(9745287),
        LIME(13544048),
        CHESTNUT(12298845),
        WENGE(6182474),
        BAOBAB(9608290),
        SEQUOIA(10050135),
        KAPOK(8156212),
        EBONY(3946288),
        MAHOGANY(7749432),
        BALSA(0xA9A299),
        WILLOW(11710818),
        WALNUT(6836802),
        GREENHEART(5144156),
        CHERRY(11895348),
        MAHOE(8362154),
        POPLAR(13619074),
        PALM(13271115),
        PAPAYA(14470005),
        PINE(12885585),
        PLUM(11364479),
        MAPLE(11431211),
        CITRUS(10266653),
        GIGANTEUM(5186590),
        IPE(5057822),
        PADAUK(11756341),
        COCOBOLO(7541506),
        ZEBRAWOOD(10912334);

        protected int color;

        private ForestryPlanks(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return I18N.localise("extratrees.block.planks.forestry." + this.toString().toLowerCase());
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks.forestry." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ItemStack getStack() {
            Item stack = Mods.forestry.item("planks");
            return new ItemStack(stack, 1, this.ordinal());
        }

        @Override
        public IIcon getIcon() {
            if (this.getStack() != null) {
                int meta = this.getStack().func_77960_j();
                Block block = ((ItemBlock)this.getStack().func_77973_b()).field_150939_a;
                return block.func_149691_a(2, meta);
            }
            return null;
        }

        @Override
        public ItemStack getFence() {
            ItemStack fence = Mods.forestry.stack("fences");
            fence.func_77964_b(this.ordinal());
            return fence;
        }
    }

    public static enum VanillaPlanks implements IPlankType,
    IFenceProvider
    {
        OAK(11833434),
        SPRUCE(8412726),
        BIRCH(14139781),
        JUNGLE(11632732),
        ACACIA(12215095),
        DARKOAK(4599061);

        protected int color;

        private VanillaPlanks(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return I18N.localise("extratrees.block.planks.vanilla." + this.toString().toLowerCase());
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks.vanilla." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ItemStack getStack() {
            return new ItemStack(Blocks.field_150344_f, 1, this.ordinal());
        }

        @Override
        public IIcon getIcon() {
            int meta = this.getStack().func_77960_j();
            Block block = Blocks.field_150344_f;
            return block.func_149691_a(2, meta);
        }

        @Override
        public ItemStack getFence() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockFence, WoodManager.getPlankTypeIndex(this));
        }
    }

    public static enum ExtraTreePlanks implements IPlankType,
    IFenceProvider
    {
        Fir(12815444),
        Cedar(14181940),
        Hemlock(13088108),
        Cypress(16169052),
        Fig(13142058),
        Beech(14784849),
        Alder(12092755),
        Hazel(13480341),
        Hornbeam(12818528),
        Box(16511430),
        Butternut(15510138),
        Hickory(14333070),
        Whitebeam(13222585),
        Elm(15772004),
        Apple(6305064),
        Yew(14722426),
        Pear(12093805),
        Hawthorn(13402978),
        Rowan(13610394),
        Elder(12489337),
        Maclura(15970862),
        Syzgium(15123393),
        Brazilwood(7487063),
        Logwood(10762028),
        Iroko(7681024),
        Locust(12816736),
        Eucalyptus(16165771),
        Purpleheart(5970991),
        Ash(16107368),
        Holly(16512743),
        Olive(11578760),
        Sweetgum(13997656),
        Rosewood(7738624),
        Gingko(16050106),
        PinkIvory(15502496);

        protected int color;
        protected IIcon icon;

        private ExtraTreePlanks(int color) {
            this.color = color;
        }

        @Override
        public String getName() {
            return I18N.localise("extratrees.block.planks." + this.toString().toLowerCase());
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ItemStack getStack() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockPlanks, this.ordinal());
        }

        public IIcon loadIcon(IIconRegister register) {
            this.icon = ExtraTrees.proxy.getIcon(register, "planks/" + this.toString());
            return this.icon;
        }

        @Override
        public IIcon getIcon() {
            return this.icon;
        }

        @Override
        public ItemStack getFence() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockFence, WoodManager.getPlankTypeIndex(this));
        }
    }
}

