/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.PowerSystem;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.util.I18N;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ComponentProcessIndefinate
extends MachineComponent
implements IProcess,
INetwork.TilePacketSync {
    private float energyPerTick;
    private boolean inProgress;
    private float actionPauseProcess;
    private float actionCancelTask;
    int clientEnergyPerSecond;

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        this.inProgress = nbt.func_74767_n("progress");
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("progress", this.inProgress);
    }

    public ComponentProcessIndefinate(IMachine machine, float energyPerTick) {
        super(machine);
        this.energyPerTick = energyPerTick;
        this.actionPauseProcess = 0.0f;
        this.actionCancelTask = 0.0f;
        this.clientEnergyPerSecond = 0;
    }

    protected IPoweredMachine getPower() {
        return this.getMachine().getInterface(IPoweredMachine.class);
    }

    @Override
    public float getEnergyPerTick() {
        return this.energyPerTick;
    }

    @Override
    public void onUpdate() {
        if (this.canWork() == null) {
            if (!this.isInProgress() && this.canProgress() == null) {
                this.onStartTask();
            } else if (this.canProgress() == null) {
                this.progressTick();
                this.onTickTask();
            }
        } else if (this.isInProgress()) {
            this.onCancelTask();
        }
        if (this.actionPauseProcess > 0.0f) {
            this.actionPauseProcess -= 1.0f;
        }
        if (this.actionCancelTask > 0.0f) {
            this.actionCancelTask -= 1.0f;
        }
        super.onUpdate();
        if (this.inProgress != this.inProgress()) {
            this.inProgress = this.inProgress();
            this.getUtil().refreshBlock();
        }
    }

    protected void progressTick() {
        this.getPower().getInterface().useEnergy(PowerSystem.RF, this.getEnergyPerTick(), true);
    }

    @Override
    public ErrorState canWork() {
        if (this.actionCancelTask == 0.0f) {
            return null;
        }
        return new ErrorState(I18N.localise("binniecore.gui.tooltip.task.canceled"), I18N.localise("binniecore.gui.tooltip.task.canceled.desc"));
    }

    @Override
    public ErrorState canProgress() {
        if (this.actionPauseProcess != 0.0f) {
            return new ErrorState(I18N.localise("binniecore.gui.tooltip.task.paused"), I18N.localise("binniecore.gui.tooltip.task.paused.desc"));
        }
        if (this.getPower().getInterface().getEnergy(PowerSystem.RF) < (double)this.getEnergyPerTick()) {
            return new ErrorState.InsufficientPower();
        }
        return null;
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    protected abstract boolean inProgress();

    protected void onCancelTask() {
    }

    protected void onStartTask() {
    }

    protected void onTickTask() {
    }

    @Override
    public String getTooltip() {
        return I18N.localise("binniecore.gui.tooltip.processing");
    }

    @Override
    public ProcessInfo getInfo() {
        return new ProcessInfo(this);
    }
}

