/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.formatter;

import gregtech.GT_Mod;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DefaultSpecialValueFormatter
implements INEISpecialInfoFormatter {
    public static DefaultSpecialValueFormatter INSTANCE = new DefaultSpecialValueFormatter();

    @Override
    public List<String> format(RecipeDisplayInfo recipeInfo) {
        int specialValue = recipeInfo.recipe.mSpecialValue;
        if (specialValue == -100 && GT_Mod.gregtechproxy.mLowGravProcessing) {
            return Collections.singletonList(GT_Utility.trans("159", "Needs Low Gravity"));
        }
        if (specialValue == -200 && GT_Mod.gregtechproxy.mEnableCleanroom) {
            return Collections.singletonList(GT_Utility.trans("160", "Needs Cleanroom"));
        }
        if (specialValue == -201) {
            return Collections.singletonList(GT_Utility.trans("206", "Scan for Assembly Line"));
        }
        if (specialValue == -300 && GT_Mod.gregtechproxy.mEnableCleanroom) {
            return Collections.singletonList(GT_Utility.trans("160.1", "Needs Cleanroom & LowGrav"));
        }
        if (specialValue == -400) {
            return Collections.singletonList(GT_Utility.trans("216", "Deprecated Recipe"));
        }
        return Collections.emptyList();
    }
}

